/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultSynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements SynchronousMetricStorage {
    private static final Logger internalLogger = Logger.getLogger(DefaultSynchronousMetricStorage.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles = new ConcurrentHashMap();
    private final AttributesProcessor attributesProcessor;
    private final int maxCardinality;
    private final ConcurrentLinkedQueue<AggregatorHandle<T, U>> aggregatorHandlePool = new ConcurrentLinkedQueue();

    DefaultSynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
    }

    Queue<AggregatorHandle<T, U>> getAggregatorHandlePool() {
        return this.aggregatorHandlePool;
    }

    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        AggregatorHandle<T, U> handle = this.getAggregatorHandle(attributes, context);
        handle.recordLong(value, attributes, context);
    }

    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        if (Double.isNaN(value)) {
            this.logger.log(Level.FINE, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded measurement Not-a-Number (NaN) value with attributes " + attributes + ". Dropping measurement.");
            return;
        }
        AggregatorHandle<T, U> handle = this.getAggregatorHandle(attributes, context);
        handle.recordDouble(value, attributes, context);
    }

    private AggregatorHandle<T, U> getAggregatorHandle(Attributes attributes, Context context) {
        AggregatorHandle<T, U> newHandle;
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        AggregatorHandle<T, U> handle = this.aggregatorHandles.get(attributes);
        if (handle != null) {
            return handle;
        }
        if (this.aggregatorHandles.size() >= this.maxCardinality) {
            this.logger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            attributes = MetricStorage.CARDINALITY_OVERFLOW;
            handle = this.aggregatorHandles.get(attributes);
            if (handle != null) {
                return handle;
            }
        }
        if ((newHandle = this.aggregatorHandlePool.poll()) == null) {
            newHandle = this.aggregator.createHandle();
        }
        return (handle = this.aggregatorHandles.putIfAbsent(attributes, newHandle)) != null ? handle : newHandle;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        boolean reset = this.aggregationTemporality == AggregationTemporality.DELTA;
        long start = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : startEpochNanos;
        ArrayList points = new ArrayList(this.aggregatorHandles.size());
        this.aggregatorHandles.forEach((attributes, handle) -> {
            Object point = handle.aggregateThenMaybeReset(start, epochNanos, (Attributes)attributes, reset);
            if (reset) {
                this.aggregatorHandles.remove(attributes, handle);
                this.aggregatorHandlePool.offer((AggregatorHandle<T, U>)handle);
            }
            if (point != null) {
                points.add(point);
            }
        });
        int toDelete = this.aggregatorHandlePool.size() - (this.maxCardinality + 1);
        for (int i = 0; i < toDelete; ++i) {
            this.aggregatorHandlePool.poll();
        }
        if (points.isEmpty()) {
            return EmptyMetricData.getInstance();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, points, this.aggregationTemporality);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

