/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.awt.geom.AffineTransform;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Equirectangular
extends AbstractProvider {
    private static final long serialVersionUID = -278288251842178001L;
    public static final String NAME = "Equidistant Cylindrical (Spherical)";
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    static final ParameterDescriptorGroup PARAMETERS;

    public Equirectangular() {
        super(2, 2, PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    public final int getEllipsoidsMask() {
        return 1;
    }

    private static double getAndStore(Parameters parameters, ParameterValueGroup parameterValueGroup, ParameterDescriptor<Double> parameterDescriptor) throws IllegalArgumentException {
        double d = parameters.doubleValue(parameterDescriptor);
        MapProjection.validate(parameterDescriptor, d);
        if (d != 0.0) {
            parameterValueGroup.parameter(parameterDescriptor.getName().getCode()).setValue(d);
        }
        return d;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        ContextualParameters contextualParameters = new ContextualParameters(this);
        double d = Equirectangular.getAndStore(parameters, contextualParameters, MapProjection.SEMI_MAJOR);
        double d2 = Equirectangular.getAndStore(parameters, contextualParameters, MapProjection.SEMI_MINOR);
        double d3 = Equirectangular.getAndStore(parameters, contextualParameters, LONGITUDE_OF_ORIGIN);
        double d4 = Equirectangular.getAndStore(parameters, contextualParameters, LATITUDE_OF_ORIGIN);
        double d5 = Equirectangular.getAndStore(parameters, contextualParameters, STANDARD_PARALLEL);
        double d6 = Equirectangular.getAndStore(parameters, contextualParameters, FALSE_EASTING);
        double d7 = Equirectangular.getAndStore(parameters, contextualParameters, FALSE_NORTHING);
        d5 = Math.toRadians(d5);
        MatrixSIS matrixSIS = contextualParameters.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.convertBefore(0, Math.cos(d5), null);
        contextualParameters.normalizeGeographicInputs(d3).convertBefore(1, null, -d4);
        if (d != d2) {
            double d8 = d2 / d;
            double d9 = Math.sin(d5);
            d = d2 / (1.0 - (1.0 - d8 * d8) * (d9 * d9));
        }
        DoubleDouble doubleDouble = DoubleDouble.createAndGuessError((double)d);
        MatrixSIS matrixSIS2 = contextualParameters.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS2.convertAfter(0, (Number)doubleDouble, (Number)DoubleDouble.createAndGuessError((double)d6));
        matrixSIS2.convertAfter(1, (Number)doubleDouble, (Number)DoubleDouble.createAndGuessError((double)d7));
        MathTransform mathTransform = contextualParameters.completeTransform(mathTransformFactory, MathTransforms.identity(2));
        if (mathTransform instanceof AffineTransform) {
            mathTransform = new ParameterizedAffine((AffineTransform)mathTransform, contextualParameters, true);
        }
        return mathTransform;
    }

    static {
        ParameterBuilder parameterBuilder = Equirectangular.builder();
        STANDARD_PARALLEL = Equirectangular.createLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8823")).addIdentifier((Citation)Citations.GEOTIFF, "3078")).addName("Latitude of 1st standard parallel")).addName((Citation)Citations.OGC, "standard_parallel_1")).addName((Citation)Citations.ESRI, "Standard_Parallel_1")).addName((Citation)Citations.NETCDF, "standard_parallel")).addName((Citation)Citations.GEOTIFF, "StdParallel1")).addName((Citation)Citations.PROJ4, "lat_ts"), false);
        LONGITUDE_OF_ORIGIN = Equirectangular.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8802")).addIdentifier((Citation)Citations.GEOTIFF, "3088")).addName("Longitude of natural origin")).addName((Citation)Citations.OGC, "central_meridian")).addName((Citation)Citations.ESRI, "Central_Meridian")).addName((Citation)Citations.NETCDF, "longitude_of_projection_origin")).addName((Citation)Citations.GEOTIFF, "CenterLong")).addName((Citation)Citations.PROJ4, "lon_0"));
        FALSE_EASTING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8806")).addIdentifier((Citation)Citations.GEOTIFF, "3082")).addName("False easting")).addName((Citation)Citations.OGC, "false_easting")).addName((Citation)Citations.ESRI, "False_Easting")).addName((Citation)Citations.NETCDF, "false_easting")).addName((Citation)Citations.GEOTIFF, "FalseEasting")).addName((Citation)Citations.PROJ4, "x_0"));
        FALSE_NORTHING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8807")).addIdentifier((Citation)Citations.GEOTIFF, "3083")).addName("False northing")).addName((Citation)Citations.OGC, "false_northing")).addName((Citation)Citations.ESRI, "False_Northing")).addName((Citation)Citations.NETCDF, "false_northing")).addName((Citation)Citations.GEOTIFF, "FalseNorthing")).addName((Citation)Citations.PROJ4, "y_0"));
        LATITUDE_OF_ORIGIN = Equirectangular.createZeroConstant(((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8801")).addIdentifier((Citation)Citations.GEOTIFF, "3089")).addName("Latitude of natural origin")).addName((Citation)Citations.OGC, "latitude_of_origin")).addName((Citation)Citations.ESRI, "Latitude_Of_Origin")).addName((Citation)Citations.NETCDF, "latitude_of_projection_origin")).addName((Citation)Citations.GEOTIFF, "CenterLat")).addName((Citation)Citations.PROJ4, "lat_0")).setRemarks((CharSequence)Resources.formatInternational((short)12, (Object)0))).setRequired(false));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)Equirectangular.addIdentifierAndLegacy(parameterBuilder, "1029", "9823").addName(NAME)).addName("Plate Carr\u00e9e")).addName((Citation)Citations.OGC, "Equirectangular")).addName((Citation)Citations.ESRI, "Plate_Carree")).addName((Citation)Citations.GEOTIFF, "CT_Equirectangular")).addName((Citation)Citations.PROJ4, "eqc")).addIdentifier((Citation)Citations.GEOTIFF, "17")).createGroupForMapProjection(STANDARD_PARALLEL, LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING);
    }
}

