/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.apache.sis.internal.referencing.j2d.Tile;
import org.apache.sis.internal.referencing.j2d.TileOrganizer;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

final class DatumShiftGridGroup<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = -1602724619897451422L;
    private final Region[] regions;

    private DatumShiftGridGroup(Tile[] tileArray, Map<Tile, DatumShiftGridFile<C, T>> map, AffineTransform2D affineTransform2D, Dimension dimension) throws IOException, NoninvertibleTransformException {
        super(map.get(tileArray[0]), affineTransform2D, dimension.width, dimension.height);
        int n = map.size();
        this.regions = new Region[n];
        this.subgrids = new DatumShiftGridFile[n];
        for (int i = 0; i < n; ++i) {
            Tile tile = tileArray[i];
            DatumShiftGridFile<C, T> datumShiftGridFile = map.get(tile);
            this.regions[i] = new Region(tile);
            this.subgrids[i] = datumShiftGridFile;
            if (!(datumShiftGridFile.accuracy > this.accuracy)) continue;
            this.accuracy = datumShiftGridFile.accuracy;
        }
    }

    static <C extends Quantity<C>, T extends Quantity<T>> DatumShiftGridGroup<C, T> create(Path path, List<DatumShiftGridFile<C, T>> list) throws IOException, FactoryException, NoninvertibleTransformException {
        TileOrganizer tileOrganizer = new TileOrganizer(null);
        LinkedHashMap<Tile, DatumShiftGridFile<C, T>> linkedHashMap = new LinkedHashMap<Tile, DatumShiftGridFile<C, T>>(Containers.hashMapCapacity((int)list.size()));
        for (DatumShiftGridFile<C, T> serializable2 : list) {
            int[] nArray = serializable2.getGridSize();
            Tile tile = new Tile(new Rectangle(nArray[0], nArray[1]), (AffineTransform)((Object)serializable2.getCoordinateToGrid().inverse()));
            if (!tileOrganizer.add(tile) || linkedHashMap.put(tile, serializable2) != null) {
                throw new AssertionError(tile);
            }
        }
        Map.Entry entry = (Map.Entry)CollectionsExt.singletonOrNull(tileOrganizer.tiles().entrySet());
        if (entry == null) {
            throw new FactoryException(Resources.format((short)94, path));
        }
        Tile tile = (Tile)entry.getKey();
        return new DatumShiftGridGroup<C, T>((Tile[])entry.getValue(), linkedHashMap, tile.getGridToCRS(), tile.getSize());
    }

    private DatumShiftGridGroup(DatumShiftGridGroup<C, T> datumShiftGridGroup, DatumShiftGridFile<C, T>[] datumShiftGridFileArray) {
        super(datumShiftGridGroup);
        this.subgrids = datumShiftGridFileArray;
        this.regions = datumShiftGridGroup.regions;
    }

    @Override
    protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
        return new DatumShiftGridGroup<C, T>(this, (DatumShiftGridFile[])objectArray);
    }

    @Override
    protected Object[] getData() {
        return this.subgrids;
    }

    @Override
    public int getTranslationDimensions() {
        return this.subgrids[0].getTranslationDimensions();
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        for (int i = 0; i < this.regions.length; ++i) {
            Region region = this.regions[i];
            if (!region.containsInclusive(n2, n3)) continue;
            double d = this.subgrids[i].getCellValue(n, Math.toIntExact(Math.round(region.x(n2))), Math.toIntExact(Math.round(region.y(n3))));
            if (this.isCellValueRatio()) {
                d *= region.relativeCellSize(n);
            }
            return d;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void interpolateInCell(double d, double d2, double[] dArray) {
        int n;
        int n2 = 0;
        Region region = this.regions[n2];
        double d3 = region.distanceSquared(d, d2);
        for (n = 1; n < this.regions.length; ++n) {
            Region region2 = this.regions[n];
            double d4 = region2.distanceSquared(d, d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            region = region2;
            n2 = n;
            if (d4 == 0.0) break;
        }
        this.subgrids[n2].interpolateInCell(region.x(d), region.y(d2), dArray);
        if (this.isCellValueRatio()) {
            for (n = 0; n < 2; ++n) {
                int n3 = n;
                dArray[n3] = dArray[n3] * region.relativeCellSize(n);
            }
        }
    }

    private static final class Region
    extends IntervalRectangle {
        private final double sx;
        private final double sy;

        Region(Tile tile) throws IOException {
            Rectangle rectangle = tile.getRegionOnFinestLevel();
            Dimension dimension = tile.getSubsampling();
            this.xmin = rectangle.getMinX();
            this.xmax = rectangle.getMaxX();
            this.ymin = rectangle.getMinY();
            this.ymax = rectangle.getMaxY();
            this.sx = dimension.width;
            this.sy = dimension.height;
        }

        final double x(double d) {
            return (d - this.xmin) / this.sx;
        }

        final double y(double d) {
            return (d - this.ymin) / this.sy;
        }

        final double relativeCellSize(int n) {
            switch (n) {
                case 0: {
                    return this.sx;
                }
                case 1: {
                    return this.sy;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

