/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

enum AxesMapper {
    SAME,
    OPPOSITE,
    POLAR;

    private static final int EAST = 1;
    private static final int NORTH = 2;

    /*
     * Enabled aggressive block sorting
     */
    public static int[] indices(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int[] nArray = new int[coordinateSystem2.getDimension()];
        long l = Numerics.bitmask((int)nArray.length) - 1L;
        long l2 = Numerics.bitmask((int)coordinateSystem.getDimension()) - 1L;
        int n = 0;
        AxesMapper[] axesMapperArray = AxesMapper.values();
        int n2 = axesMapperArray.length;
        int n3 = 0;
        while (true) {
            int n4;
            long l3;
            AxesMapper axesMapper;
            if (n3 < n2) {
                axesMapper = axesMapperArray[n3];
                l3 = l;
            } else {
                if (l != 0L) return null;
                int[] nArray2 = nArray;
                return nArray2;
            }
            while (AxesMapper.hasMore(n4 = Long.numberOfTrailingZeros(l3))) {
                long l4;
                block21: {
                    int n5;
                    l4 = AxesMapper.clearMask(n4);
                    AxisDirection axisDirection = coordinateSystem2.getAxis(n4).getDirection();
                    block0 : switch (axesMapper) {
                        case OPPOSITE: {
                            AxisDirection axisDirection2 = axisDirection;
                            axisDirection = AxisDirections.opposite(axisDirection);
                            if (axisDirection2 != axisDirection && axisDirection != null) break;
                            break block21;
                        }
                        case POLAR: {
                            if (!CoordinateSystems.isAlongMeridian(axisDirection)) break;
                            switch (n) {
                                case 0: 
                                case 2: {
                                    axisDirection = AxisDirection.EAST;
                                    break block0;
                                }
                                case 1: {
                                    axisDirection = AxisDirection.NORTH;
                                    break block0;
                                }
                            }
                            return null;
                        }
                    }
                    long l5 = l2;
                    while (AxesMapper.hasMore(n5 = Long.numberOfTrailingZeros(l5))) {
                        long l6 = AxesMapper.clearMask(n5);
                        AxisDirection axisDirection3 = coordinateSystem.getAxis(n5).getDirection();
                        if (axesMapper == POLAR && CoordinateSystems.isAlongMeridian(axisDirection3)) {
                            switch (n) {
                                case 0: 
                                case 2: {
                                    axisDirection3 = AxisDirection.EAST;
                                    break;
                                }
                                case 1: {
                                    axisDirection3 = AxisDirection.NORTH;
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                        }
                        if (axisDirection.equals((Object)axisDirection3)) {
                            if (axisDirection.equals((Object)AxisDirection.EAST)) {
                                n |= 1;
                            }
                            if (axisDirection.equals((Object)AxisDirection.NORTH)) {
                                n |= 2;
                            }
                            nArray[n4] = n5;
                            l2 &= l6;
                            if ((l &= l4) != 0L) break;
                            return nArray;
                        }
                        l5 &= l6;
                    }
                }
                l3 &= l4;
            }
            ++n3;
        }
    }

    private static boolean hasMore(int n) {
        return (n & 0xFFFFFFC0) == 0;
    }

    private static long clearMask(int n) {
        return 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

