/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

final class CacheKey {
    final Class<?> type;
    final Class<?> propertyType;

    CacheKey(Class<?> clazz) {
        this.type = clazz;
        this.propertyType = Object.class;
    }

    CacheKey(Class<?> clazz, Class<?> clazz2) {
        this.type = clazz;
        this.propertyType = clazz2 != null ? clazz2 : Object.class;
    }

    final boolean isValid() {
        return this.type != null && this.propertyType.isAssignableFrom(this.type);
    }

    public int hashCode() {
        int n = this.propertyType.hashCode();
        if (this.type != null) {
            n += 31 * this.type.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CacheKey) {
            CacheKey cacheKey = (CacheKey)object;
            return this.type == cacheKey.type && this.propertyType == cacheKey.propertyType;
        }
        return false;
    }

    public String toString() {
        String string = Classes.getShortName(this.type);
        if (this.propertyType != Object.class) {
            string = string + " as " + Classes.getShortName(this.propertyType);
        }
        return string;
    }

    final String unrecognized() {
        return Errors.format((short)149, this.type);
    }

    final String invalid() {
        return Errors.format((short)43, (Object)"type", this.propertyType, this.type);
    }
}

