/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.internal.jaxb.gco.ObjectReference;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.XLink;
import org.opengis.util.InternationalString;

public abstract class PropertyType<ValueType extends PropertyType<ValueType, BoundType>, BoundType>
extends XmlAdapter<ValueType, BoundType> {
    protected BoundType metadata;
    private Object reference;

    protected PropertyType() {
    }

    protected PropertyType(BoundType BoundType, boolean bl) {
        Object object;
        this.metadata = BoundType;
        if (bl && (object = PrimitiveTypeProperties.property(BoundType)) instanceof NilReason) {
            this.reference = object.toString();
            this.metadata = null;
        }
    }

    protected PropertyType(BoundType BoundType) {
        Serializable serializable;
        if (BoundType instanceof NilObject && (serializable = ((NilObject)BoundType).getNilReason()) != null) {
            this.reference = ((NilReason)serializable).toString();
            return;
        }
        serializable = this.getBoundType();
        Context context = Context.current();
        ReferenceResolver referenceResolver = Context.resolver(context);
        String string = Context.getObjectID(context, BoundType);
        if (string != null && referenceResolver.canSubstituteByReference((MarshalContext)context, serializable, BoundType, string)) {
            try {
                XLink xLink = new XLink();
                xLink.setHRef(new URI(null, null, string));
                this.reference = new ObjectReference(null, xLink);
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                Context.warningOccured(context, ((Object)((Object)this)).getClass(), "<init>", uRISyntaxException, true);
            }
        }
        this.metadata = BoundType;
        if (BoundType instanceof IdentifiedObject) {
            IdentifierMap identifierMap = ((IdentifiedObject)BoundType).getIdentifierMap();
            XLink xLink = identifierMap.getSpecialized(IdentifierSpace.XLINK);
            UUID uUID = identifierMap.getSpecialized(IdentifierSpace.UUID);
            if (uUID != null || xLink != null) {
                if (uUID != null) {
                    if (referenceResolver.canSubstituteByReference((MarshalContext)context, serializable, BoundType, uUID)) {
                        this.metadata = null;
                    } else {
                        uUID = null;
                    }
                }
                if (xLink != null && referenceResolver.canSubstituteByReference((MarshalContext)context, serializable, BoundType, xLink)) {
                    this.metadata = null;
                }
                if (uUID != null || xLink != null) {
                    this.reference = new ObjectReference(uUID, xLink);
                }
            }
        }
    }

    private ObjectReference reference(boolean bl) {
        Object object = this.reference;
        if (object instanceof ObjectReference) {
            return (ObjectReference)object;
        }
        if (bl) {
            ObjectReference objectReference = new ObjectReference();
            this.reference = objectReference;
            return objectReference;
        }
        return null;
    }

    private XLink xlink(boolean bl) {
        ObjectReference objectReference = this.reference(bl);
        if (objectReference == null) {
            return null;
        }
        XLink xLink = objectReference.xlink;
        if (bl && xLink == null) {
            objectReference.xlink = xLink = new XLink();
            xLink.setType(XLink.Type.SIMPLE);
        }
        return xLink;
    }

    @XmlAttribute(name="nilReason", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    public final String getNilReason() {
        Object object = this.reference;
        return object instanceof String ? (String)object : null;
    }

    public final void setNilReason(String string) {
        if (!(this.reference instanceof ObjectReference)) {
            this.reference = string;
        }
    }

    @XmlAttribute(name="uuidref")
    public final String getUUIDREF() {
        ObjectReference objectReference = this.reference(false);
        return objectReference != null ? PropertyType.toString(objectReference.uuid) : null;
    }

    public final void setUUIDREF(String string) throws IllegalArgumentException {
        Context context = Context.current();
        this.reference((boolean)true).uuid = Context.converter(context).toUUID(context, string);
    }

    private static String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    private static URI toURI(String string) throws URISyntaxException {
        Context context = Context.current();
        return Context.converter(context).toURI((MarshalContext)context, string);
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    public final String getHRef() {
        XLink xLink = this.xlink(false);
        return xLink != null ? PropertyType.toString(xLink.getHRef()) : null;
    }

    public final void setHRef(String string) throws URISyntaxException {
        this.xlink(true).setHRef(PropertyType.toURI(string));
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="role", namespace="http://www.w3.org/1999/xlink")
    public final String getRole() {
        XLink xLink = this.xlink(false);
        return xLink != null ? PropertyType.toString(xLink.getRole()) : null;
    }

    public final void setRole(String string) throws URISyntaxException {
        this.xlink(true).setRole(PropertyType.toURI(string));
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="arcrole", namespace="http://www.w3.org/1999/xlink")
    public final String getArcRole() {
        XLink xLink = this.xlink(false);
        return xLink != null ? PropertyType.toString(xLink.getArcRole()) : null;
    }

    public final void setArcRole(String string) throws URISyntaxException {
        this.xlink(true).setArcRole(PropertyType.toURI(string));
    }

    @XmlAttribute(name="title", namespace="http://www.w3.org/1999/xlink")
    public final String getTitle() {
        XLink xLink = this.xlink(false);
        return xLink != null ? StringAdapter.toString((CharSequence)xLink.getTitle()) : null;
    }

    public final void setTitle(String string) {
        if ((string = Strings.trimOrNull((String)string)) != null) {
            this.xlink(true).setTitle((InternationalString)new SimpleInternationalString(string));
        }
    }

    @XmlAttribute(name="show", namespace="http://www.w3.org/1999/xlink")
    public final XLink.Show getShow() {
        XLink xLink = this.xlink(false);
        return xLink != null ? xLink.getShow() : null;
    }

    public final void setShow(XLink.Show show) {
        this.xlink(true).setShow(show);
    }

    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    public final XLink.Actuate getActuate() {
        XLink xLink = this.xlink(false);
        return xLink != null ? xLink.getActuate() : null;
    }

    public final void setActuate(XLink.Actuate actuate) {
        this.xlink(true).setActuate(actuate);
    }

    protected abstract Class<BoundType> getBoundType();

    protected final boolean accept2014() {
        return FilterByVersion.CURRENT_METADATA.accept();
    }

    protected abstract ValueType wrap(BoundType var1);

    public final ValueType marshal(BoundType BoundType) {
        if (BoundType == null) {
            return null;
        }
        return this.wrap(BoundType);
    }

    public BoundType unmarshal(ValueType ValueType) throws URISyntaxException {
        return ValueType != null ? (BoundType)((PropertyType)((Object)ValueType)).resolve(Context.current()) : null;
    }

    final BoundType resolve(Context context) throws URISyntaxException {
        NilReason nilReason;
        String string;
        ObjectReference objectReference = this.reference(false);
        if (objectReference != null) {
            this.metadata = objectReference.resolve(context, this.getBoundType(), this.metadata);
        }
        if (this.metadata == null && (string = this.getNilReason()) != null && (nilReason = Context.converter(context).toNilReason(context, string)) != null) {
            this.metadata = nilReason.createNilObject(this.getBoundType());
        }
        return this.metadata;
    }

    protected final void incomplete(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(Errors.format((short)85, this.getBoundType(), (Object)string));
    }
}

