/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.Serializable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public class IdentifierMapAdapter
extends AbstractMap<Citation, String>
implements IdentifierMap,
Serializable {
    private static final long serialVersionUID = -1445849218952061605L;
    public static final IdentifierMap EMPTY = new IdentifierMapAdapter(Collections.emptySet());
    public final Collection<Identifier> identifiers;

    public IdentifierMapAdapter(Collection<Identifier> collection) {
        this.identifiers = collection;
    }

    static int specialCase(Object object) {
        if (object == IdentifierSpace.HREF) {
            return 2;
        }
        return -1;
    }

    private URI getHRef() {
        Object t;
        Identifier identifier = this.getIdentifier(IdentifierSpace.XLINK);
        if (identifier instanceof SpecializedIdentifier && (t = ((SpecializedIdentifier)identifier).value) instanceof XLink) {
            return ((XLink)t).getHRef();
        }
        return null;
    }

    private static String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    boolean isModifiable() {
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.identifiers.isEmpty();
    }

    @Override
    public final int size() {
        HashSet<Citation> hashSet = new HashSet<Citation>(Containers.hashMapCapacity((int)this.identifiers.size()));
        for (Identifier identifier : this.identifiers) {
            if (identifier == null) continue;
            hashSet.add(identifier.getAuthority());
        }
        return hashSet.size();
    }

    @Override
    public final boolean containsValue(Object object) {
        if (object instanceof String) {
            for (Identifier identifier : this.identifiers) {
                if (identifier == null || !object.equals(identifier.getCode())) continue;
                return true;
            }
            return object.equals(IdentifierMapAdapter.toString(this.getHRef()));
        }
        return false;
    }

    @Override
    public final boolean containsKey(Object object) {
        if (object instanceof Citation) {
            if (this.getIdentifier((Citation)object) != null) {
                return true;
            }
            switch (IdentifierMapAdapter.specialCase(object)) {
                case 2: {
                    return this.getHRef() != null;
                }
            }
        }
        return false;
    }

    final Identifier getIdentifier(Citation citation) {
        for (Identifier identifier : this.identifiers) {
            if (identifier == null || !Objects.equals(citation, identifier.getAuthority())) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public final <T> T getSpecialized(IdentifierSpace<T> identifierSpace) {
        Identifier identifier = this.getIdentifier(identifierSpace);
        if (identifier instanceof SpecializedIdentifier) {
            return ((SpecializedIdentifier)identifier).value;
        }
        switch (IdentifierMapAdapter.specialCase(identifierSpace)) {
            case 2: {
                return (T)this.getHRef();
            }
        }
        return null;
    }

    @Override
    public final String get(Object object) {
        if (object instanceof Citation) {
            Identifier identifier = this.getIdentifier((Citation)object);
            if (identifier != null) {
                return identifier.getCode();
            }
            switch (IdentifierMapAdapter.specialCase(object)) {
                case 2: {
                    return IdentifierMapAdapter.toString(this.getHRef());
                }
            }
        }
        return null;
    }

    @Override
    public String remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String put(Citation citation, String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Citation, String>> entrySet() {
        return new SetOfUnknownSize<Map.Entry<Citation, String>>(){

            public void clear() throws UnsupportedOperationException {
                IdentifierMapAdapter.this.clear();
            }

            public boolean isEmpty() {
                return IdentifierMapAdapter.this.isEmpty();
            }

            public int size() {
                return IdentifierMapAdapter.this.size();
            }

            public Iterator<Map.Entry<Citation, String>> iterator() {
                return new Iter(IdentifierMapAdapter.this.identifiers, IdentifierMapAdapter.this.isModifiable());
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50).append('{');
        for (Map.Entry<Citation, String> entry : this.entrySet()) {
            if (stringBuilder.length() != 1) {
                stringBuilder.append(", ");
            }
            SpecializedIdentifier.format(stringBuilder, entry.getKey(), entry.getValue());
        }
        return stringBuilder.append('}').toString();
    }

    private static final class Iter
    extends HashMap<Citation, Boolean>
    implements Iterator<Map.Entry<Citation, String>> {
        private Iterator<? extends Identifier> identifiers;
        private transient Map.Entry<Citation, String> next;
        private transient Citation authority;
        private final boolean isModifiable;

        Iter(Collection<? extends Identifier> collection, boolean bl) {
            super(Containers.hashMapCapacity((int)collection.size()));
            this.identifiers = collection.iterator();
            this.isModifiable = bl;
        }

        private void toNext() {
            Iterator<? extends Identifier> iterator = this.identifiers;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Identifier identifier = iterator.next();
                    if (identifier == null) continue;
                    Citation citation = identifier.getAuthority();
                    Boolean bl = this.put(citation, Boolean.FALSE);
                    if (bl == null) {
                        this.next = identifier instanceof IdentifierMapEntry ? (IdentifierMapEntry)identifier : new IdentifierMapEntry.Immutable(citation, identifier.getCode());
                        this.authority = citation;
                        return;
                    }
                    if (!bl.booleanValue()) continue;
                    iterator.remove();
                }
                this.identifiers = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.toNext();
            }
            return this.identifiers != null;
        }

        @Override
        public Map.Entry<Citation, String> next() throws NoSuchElementException {
            Map.Entry<Citation, String> entry = this.next;
            if (entry == null) {
                this.toNext();
                entry = this.next;
            }
            this.next = null;
            if (this.identifiers == null) {
                throw new NoSuchElementException();
            }
            return entry;
        }

        @Override
        public void remove() throws IllegalStateException {
            if (!this.isModifiable) {
                throw new UnsupportedOperationException();
            }
            Iterator<? extends Identifier> iterator = this.identifiers;
            if (iterator == null || this.next != null) {
                throw new IllegalStateException();
            }
            iterator.remove();
            this.put(this.authority, Boolean.TRUE);
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return Strings.toString(Iter.class, (Object[])new Object[]{"next", this.next});
        }
    }
}

