/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.TileObserver;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import org.apache.sis.util.ArraysExt;

public final class WriteSupport {
    private WriteSupport() {
    }

    public static TileObserver[] addTileObserver(TileObserver[] tileObserverArray, TileObserver tileObserver) {
        if (tileObserver != null) {
            if (tileObserverArray == null) {
                return new TileObserver[]{tileObserver};
            }
            int n = tileObserverArray.length;
            tileObserverArray = Arrays.copyOf(tileObserverArray, n + 1);
            tileObserverArray[n] = tileObserver;
        }
        return tileObserverArray;
    }

    public static TileObserver[] removeTileObserver(TileObserver[] tileObserverArray, TileObserver tileObserver) {
        if (tileObserverArray != null) {
            int n = tileObserverArray.length;
            while (--n >= 0) {
                if (tileObserverArray[n] != tileObserver) continue;
                return (TileObserver[])ArraysExt.remove((Object[])tileObserverArray, (int)n, (int)1);
            }
        }
        return tileObserverArray;
    }

    public static void fireTileUpdate(TileObserver[] tileObserverArray, WritableRenderedImage writableRenderedImage, int n, int n2, boolean bl) {
        if (tileObserverArray != null) {
            for (TileObserver tileObserver : tileObserverArray) {
                tileObserver.tileUpdate(writableRenderedImage, n, n2, bl);
            }
        }
    }
}

