/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.logging.Level;
import java.util.stream.Collector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.CommonExecutor;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;

public class TileOpExecutor {
    private final int minTileX;
    private final int minTileY;
    private final int maxTileX;
    private final int maxTileY;
    private Shape areaOfInterest;
    private TileErrorHandler errorHandler = TileErrorHandler.THROW;

    public TileOpExecutor(RenderedImage renderedImage, Rectangle rectangle) {
        if (rectangle != null) {
            int n = renderedImage.getTileWidth();
            int n2 = renderedImage.getTileHeight();
            long l = renderedImage.getTileGridXOffset();
            long l2 = renderedImage.getTileGridYOffset();
            this.minTileX = Math.toIntExact(Math.floorDiv((long)rectangle.x - l, (long)n));
            this.minTileY = Math.toIntExact(Math.floorDiv((long)rectangle.y - l2, (long)n2));
            this.maxTileX = Math.toIntExact(Math.floorDiv((long)rectangle.x + ((long)rectangle.width - 1L) - l, (long)n));
            this.maxTileY = Math.toIntExact(Math.floorDiv((long)rectangle.y + ((long)rectangle.height - 1L) - l2, (long)n2));
        } else {
            this.minTileX = renderedImage.getMinTileX();
            this.minTileY = renderedImage.getMinTileY();
            this.maxTileX = Math.addExact(this.minTileX, renderedImage.getNumXTiles() - 1);
            this.maxTileY = Math.addExact(this.minTileY, renderedImage.getNumYTiles() - 1);
        }
    }

    public final void setAreaOfInterest(RenderedImage renderedImage, Shape shape) {
        if (shape != null && renderedImage != null) {
            Rectangle rectangle = this.getTileIndices();
            rectangle.x = Math.decrementExact(ImageUtilities.tileToPixelX(renderedImage, Math.incrementExact(rectangle.x)) - 1);
            rectangle.y = Math.decrementExact(ImageUtilities.tileToPixelY(renderedImage, Math.incrementExact(rectangle.y)) - 1);
            rectangle.width = Math.addExact(Math.multiplyExact(rectangle.width, renderedImage.getTileWidth() - 2), 2);
            rectangle.height = Math.addExact(Math.multiplyExact(rectangle.height, renderedImage.getTileHeight() - 2), 2);
            if (shape.contains(rectangle)) {
                shape = null;
            }
        }
        this.areaOfInterest = shape;
    }

    public final void setErrorHandler(ErrorHandler errorHandler, Class<?> clazz, String string) {
        ArgumentChecks.ensureNonNull((String)"handler", (Object)errorHandler);
        this.errorHandler = errorHandler == ErrorHandler.THROW ? TileErrorHandler.THROW : new TileErrorHandler(errorHandler, clazz, string);
    }

    public final boolean isMultiTiled() {
        return (this.maxTileX - this.minTileX | this.maxTileY - this.minTileY) > 0;
    }

    public final Rectangle getTileIndices() {
        return new Rectangle(this.minTileX, this.minTileY, Math.incrementExact(Math.subtractExact(this.maxTileX, this.minTileX)), Math.incrementExact(Math.subtractExact(this.maxTileY, this.minTileY)));
    }

    protected void readFrom(Raster raster) throws Exception {
    }

    protected void writeTo(WritableRaster writableRaster) throws Exception {
    }

    public final void readFrom(RenderedImage renderedImage) {
        ErrorHandler.Report report = new ErrorHandler.Report();
        block2: for (int i = this.minTileY; i <= this.maxTileY; ++i) {
            for (int j = this.minTileX; j <= this.maxTileX; ++j) {
                try {
                    this.readFrom(renderedImage.getTile(j, i));
                    continue;
                }
                catch (Exception exception) {
                    report.add(new Point(j, i), TileOpExecutor.trimImagingWrapper(exception), null);
                    if (this.errorHandler == TileErrorHandler.THROW) continue block2;
                }
            }
        }
        this.errorHandler.publish(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(WritableRenderedImage writableRenderedImage) {
        ErrorHandler.Report report = new ErrorHandler.Report();
        for (int i = this.minTileY; i <= this.maxTileY; ++i) {
            for (int j = this.minTileX; j <= this.maxTileX; ++j) {
                try {
                    WritableRaster writableRaster = writableRenderedImage.getWritableTile(j, i);
                    try {
                        this.writeTo(writableRaster);
                        continue;
                    }
                    finally {
                        writableRenderedImage.releaseWritableTile(j, i);
                    }
                }
                catch (Exception exception) {
                    Point point = new Point(j, i);
                    report.add(point, TileOpExecutor.trimImagingWrapper(exception), () -> Resources.forLocale(null).getLogRecord(Level.WARNING, (short)14, point.x, point.y));
                }
            }
        }
        this.errorHandler.publish(report);
    }

    public final void parallelReadFrom(RenderedImage renderedImage) {
        if (this.isMultiTiled()) {
            this.executeOnReadable(renderedImage, TileOpExecutor.executor((void_, raster) -> {
                try {
                    this.readFrom((Raster)raster);
                }
                catch (Exception exception) {
                    throw Worker.rethrowOrWrap(exception);
                }
            }));
        } else {
            this.readFrom(renderedImage);
        }
    }

    public final void parallelWriteTo(WritableRenderedImage writableRenderedImage) {
        if (this.isMultiTiled()) {
            this.executeOnWritable(writableRenderedImage, TileOpExecutor.executor((void_, writableRaster) -> {
                try {
                    this.writeTo((WritableRaster)writableRaster);
                }
                catch (Exception exception) {
                    throw Worker.rethrowOrWrap(exception);
                }
            }));
        } else {
            this.writeTo(writableRenderedImage);
        }
    }

    private static <RT extends Raster> Collector<RT, Void, Void> executor(BiConsumer<Void, RT> biConsumer) {
        return Collector.of(() -> null, biConsumer, (void_, void_2) -> void_, new Collector.Characteristics[0]);
    }

    public final <A, R> R executeOnReadable(RenderedImage renderedImage, Collector<? super Raster, A, R> collector) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)renderedImage);
        ArgumentChecks.ensureNonNull((String)"collector", collector);
        return ReadWork.execute(this, renderedImage, collector, this.errorHandler);
    }

    public final <A, R> R executeOnWritable(WritableRenderedImage writableRenderedImage, Collector<? super WritableRaster, A, R> collector) {
        ArgumentChecks.ensureNonNull((String)"target", (Object)writableRenderedImage);
        ArgumentChecks.ensureNonNull((String)"collector", collector);
        return WriteWork.execute(this, writableRenderedImage, collector, this.errorHandler);
    }

    private static Throwable trimImagingWrapper(Throwable throwable) {
        while (throwable.getClass() == ImagingOpException.class && throwable.getMessage() == null && throwable.getSuppressed().length == 0) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                return throwable;
            }
            throwable = throwable2;
        }
        if (throwable instanceof Exception) {
            throwable = Exceptions.unwrap((Exception)((Exception)throwable));
        }
        return throwable;
    }

    private static final class ReadWork<A>
    extends Worker<RenderedImage, Raster, A> {
        private ReadWork(Cursor<RenderedImage, A> cursor, Collector<? super Raster, A, ?> collector) {
            super(cursor, collector);
        }

        @Override
        protected void executeOnCurrentTile() {
            Raster raster = this.cursor.image.getTile(this.tx, this.ty);
            this.processor.accept(this.accumulator, raster);
        }

        static <A, R> R execute(TileOpExecutor tileOpExecutor, RenderedImage renderedImage, Collector<? super Raster, A, R> collector, TileErrorHandler tileErrorHandler) {
            TileOpExecutor tileOpExecutor2 = tileOpExecutor;
            Objects.requireNonNull(tileOpExecutor2);
            Cursor cursor = new Cursor(tileOpExecutor2, renderedImage, collector, tileErrorHandler.isThrow());
            Future[] futureArray = new Future[cursor.getNumWorkers()];
            for (int i = 0; i < futureArray.length; ++i) {
                futureArray[i] = CommonExecutor.instance().submit(new ReadWork<A>(cursor, collector));
            }
            ReadWork<A> readWork = new ReadWork<A>(cursor, collector);
            readWork.run();
            return cursor.finish(futureArray, collector, tileErrorHandler);
        }
    }

    private static final class WriteWork<A>
    extends Worker<WritableRenderedImage, WritableRaster, A> {
        private WriteWork(Cursor<WritableRenderedImage, A> cursor, Collector<? super WritableRaster, A, ?> collector) {
            super(cursor, collector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void executeOnCurrentTile() {
            WritableRenderedImage writableRenderedImage = (WritableRenderedImage)this.cursor.image;
            int n = this.tx;
            int n2 = this.ty;
            WritableRaster writableRaster = writableRenderedImage.getWritableTile(n, n2);
            try {
                this.processor.accept(this.accumulator, writableRaster);
            }
            finally {
                writableRenderedImage.releaseWritableTile(n, n2);
            }
        }

        static <A, R> R execute(TileOpExecutor tileOpExecutor, WritableRenderedImage writableRenderedImage, Collector<? super WritableRaster, A, R> collector, TileErrorHandler tileErrorHandler) {
            TileOpExecutor tileOpExecutor2 = tileOpExecutor;
            Objects.requireNonNull(tileOpExecutor2);
            Cursor cursor = new Cursor(tileOpExecutor2, (RenderedImage)writableRenderedImage, collector, false);
            Future[] futureArray = new Future[cursor.getNumWorkers()];
            for (int i = 0; i < futureArray.length; ++i) {
                futureArray[i] = CommonExecutor.instance().submit(new WriteWork<A>(cursor, collector));
            }
            WriteWork<A> writeWork = new WriteWork<A>(cursor, collector);
            writeWork.run();
            return cursor.finish(futureArray, collector, tileErrorHandler);
        }
    }

    private static abstract class Worker<RI extends RenderedImage, RT extends Raster, A>
    implements Runnable {
        protected final Cursor<RI, A> cursor;
        protected int tx;
        protected int ty;
        protected final BiConsumer<A, ? super RT> processor;
        protected final A accumulator;

        protected Worker(Cursor<RI, A> cursor, Collector<? super RT, A, ?> collector) {
            this.cursor = cursor;
            this.processor = collector.accumulator();
            this.accumulator = collector.supplier().get();
        }

        @Override
        public final void run() {
            while (this.cursor.next(this)) {
                try {
                    if (!this.cursor.intersectAOI(this)) continue;
                    this.executeOnCurrentTile();
                }
                catch (Exception exception) {
                    this.cursor.recordError(new Point(this.tx, this.ty), TileOpExecutor.trimImagingWrapper(exception));
                }
            }
            this.cursor.accumulate(this.accumulator);
        }

        protected abstract void executeOnCurrentTile();

        static ImagingOpException rethrowOrWrap(Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            return (ImagingOpException)new ImagingOpException(null).initCause(throwable2 != null ? throwable2 : throwable);
        }
    }

    private final class Cursor<RI extends RenderedImage, A>
    extends AtomicInteger {
        final RI image;
        private final int numXTiles;
        private final BinaryOperator<A> combiner;
        private A accumulator;
        private final ErrorHandler.Report errors;
        private final boolean stopOnError;
        final /* synthetic */ TileOpExecutor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        Cursor(RI RI, Collector<?, A, ?> collector, boolean bl) {
            this.this$0 = (TileOpExecutor)n;
            this.image = RI;
            this.combiner = collector.combiner();
            this.numXTiles = Math.incrementExact(Math.subtractExact(((TileOpExecutor)n).maxTileX, ((TileOpExecutor)n).minTileX));
            this.stopOnError = bl;
            this.errors = new ErrorHandler.Report();
        }

        final int getNumWorkers() {
            return Math.max((int)Math.min((long)CommonExecutor.PARALLELISM, (long)this.numXTiles * ((long)this.this$0.maxTileY - (long)this.this$0.minTileY + 1L) - 1L), 0);
        }

        final boolean next(Worker<RI, ?, A> worker) {
            int n = this.getAndIncrement();
            if (n >= 0) {
                worker.tx = Math.addExact(this.this$0.minTileX, n % this.numXTiles);
                worker.ty = Math.addExact(this.this$0.minTileY, n / this.numXTiles);
                return worker.ty <= this.this$0.maxTileY;
            }
            return false;
        }

        final boolean intersectAOI(Worker<RI, ?, A> worker) {
            if (this.this$0.areaOfInterest == null) {
                return true;
            }
            Rectangle rectangle = new Rectangle(this.image.getTileWidth(), this.image.getTileHeight());
            rectangle.x = Math.addExact(Math.multiplyExact(worker.tx, rectangle.width), this.image.getTileGridXOffset());
            rectangle.y = Math.addExact(Math.multiplyExact(worker.ty, rectangle.height), this.image.getTileGridYOffset());
            return this.this$0.areaOfInterest.intersects(rectangle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void accumulate(A a) {
            if (a != null) {
                Cursor cursor = this;
                synchronized (cursor) {
                    this.accumulator = this.accumulator == null ? a : this.combiner.apply(this.accumulator, a);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        final <R> R finish(Future<?>[] futureArray, Collector<?, A, R> collector, TileErrorHandler tileErrorHandler) {
            R r;
            void object;
            boolean i = false;
            while (object < futureArray.length) {
                if (CommonExecutor.unschedule(futureArray[object])) {
                    futureArray[object] = null;
                }
                ++object;
            }
            for (Future<?> future : futureArray) {
                try {
                    if (future == null) continue;
                    future.get();
                }
                catch (ExecutionException executionException) {
                    throw Worker.rethrowOrWrap(executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    this.recordError(null, interruptedException);
                    break;
                }
            }
            Cursor cursor = this;
            synchronized (cursor) {
                r = collector.finisher().apply(this.accumulator);
            }
            tileErrorHandler.publish(this.errors);
            return r;
        }

        final void recordError(Point point, Throwable throwable) {
            if (this.stopOnError) {
                this.set(Integer.MIN_VALUE);
            }
            this.errors.add(point, throwable, null);
        }

        @Override
        public String toString() {
            int n = this.get();
            String string = "done";
            if (n >= 0) {
                int n2 = Math.addExact(this.this$0.minTileX, n % this.numXTiles);
                int n3 = Math.addExact(this.this$0.minTileY, n / this.numXTiles);
                if (n3 <= this.this$0.maxTileY) {
                    string = "(" + n2 + ", " + n3 + ')';
                }
            }
            return Strings.toString(this.getClass(), (Object[])new Object[]{"image", Classes.getShortClassName(this.image), "numWorkers", this.getNumWorkers(), "tile", string});
        }
    }
}

