/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.filter.BinaryGeometryFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Geometry;

final class DistanceFilter<R, G>
extends BinaryGeometryFilter<R, G> {
    private static final long serialVersionUID = -5304631042699647889L;
    private final DistanceOperatorName operatorType;
    private final Quantity<Length> distance;

    DistanceFilter(DistanceOperatorName distanceOperatorName, Geometries<G> geometries, Expression<? super R, ?> expression, Expression<? super R, ?> expression2, Quantity<Length> quantity) {
        super(geometries, expression, expression2, quantity.getUnit().getSystemUnit());
        ArgumentChecks.ensureNonNull((String)"operatorType", (Object)((Object)distanceOperatorName));
        this.operatorType = distanceOperatorName;
        this.distance = quantity;
    }

    @Override
    protected BinaryGeometryFilter<R, G> recreate(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new DistanceFilter(this.operatorType, DistanceFilter.getGeometryLibrary(this.expression1), expression, expression2, this.distance);
    }

    public DistanceOperatorName getOperatorType() {
        return this.operatorType;
    }

    @Override
    public List<Expression<? super R, ?>> getExpressions() {
        return Arrays.asList(DistanceFilter.original(this.expression1), DistanceFilter.original(this.expression2), new LeafExpression.Literal(this.distance));
    }

    @Override
    protected Collection<?> getChildren() {
        return Arrays.asList(DistanceFilter.original(this.expression1), DistanceFilter.original(this.expression2), this.distance);
    }

    public Quantity<Length> getDistance() {
        return this.distance;
    }

    public Geometry getGeometry() {
        Literal literal;
        if (this.expression2 instanceof Literal) {
            literal = (Literal)this.expression2;
        } else if (this.expression1 instanceof Literal) {
            literal = (Literal)this.expression1;
        } else {
            throw new IllegalStateException();
        }
        return (Geometry)literal.getValue();
    }

    @Override
    public boolean test(R r) {
        GeometryWrapper geometryWrapper;
        GeometryWrapper geometryWrapper2 = (GeometryWrapper)this.expression1.apply(r);
        if (geometryWrapper2 != null && (geometryWrapper = (GeometryWrapper)this.expression2.apply(r)) != null) {
            try {
                return geometryWrapper2.predicate(this.operatorType, geometryWrapper, this.distance, this.context);
            }
            catch (RuntimeException runtimeException) {
                this.warning(runtimeException, true);
            }
        }
        return this.negativeResult();
    }

    @Override
    protected boolean negativeResult() {
        return SpatialOperationContext.negativeResult(this.operatorType);
    }
}

