/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;

abstract class BinaryFunction<R, V1, V2>
extends Node {
    private static final long serialVersionUID = -8632475810190545852L;
    protected final Expression<? super R, ? extends V1> expression1;
    protected final Expression<? super R, ? extends V2> expression2;

    protected BinaryFunction(Expression<? super R, ? extends V1> expression, Expression<? super R, ? extends V2> expression2) {
        ArgumentChecks.ensureNonNull((String)"expression1", expression);
        ArgumentChecks.ensureNonNull((String)"expression2", expression2);
        this.expression1 = expression;
        this.expression2 = expression2;
    }

    public final List<Expression<? super R, ?>> getParameters() {
        return this.getExpressions();
    }

    public List<Expression<? super R, ?>> getExpressions() {
        return Arrays.asList(this.expression1, this.expression2);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getExpressions();
    }

    protected final Number apply(Number number, Number number2) {
        int n = Math.max(Numbers.getEnumConstant(number.getClass()), Numbers.getEnumConstant(number2.getClass()));
        try {
            switch (n) {
                case 11: {
                    return this.applyAsDecimal((BigDecimal)Numbers.cast((Number)number, BigDecimal.class), (BigDecimal)Numbers.cast((Number)number2, BigDecimal.class));
                }
                case 10: {
                    return this.applyAsInteger((BigInteger)Numbers.cast((Number)number, BigInteger.class), (BigInteger)Numbers.cast((Number)number2, BigInteger.class));
                }
                case 7: {
                    return this.applyAsFraction((Fraction)Numbers.cast((Number)number, Fraction.class), (Fraction)Numbers.cast((Number)number2, Fraction.class));
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return this.applyAsLong(number.longValue(), number2.longValue());
                }
            }
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            this.warning(runtimeException, true);
        }
        return this.applyAsDouble(number instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)number).floatValue()) : number.doubleValue(), number2 instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)number2).floatValue()) : number2.doubleValue());
    }

    protected Number applyAsLong(long l, long l2) {
        return null;
    }

    protected Number applyAsDouble(double d, double d2) {
        return null;
    }

    protected Number applyAsFraction(Fraction fraction, Fraction fraction2) {
        return null;
    }

    protected Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        return null;
    }

    protected Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return null;
    }
}

