/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

public class LogicFunction {
    private static BooleanValueStream createBitwiseFunction(String name, LambdaFunction.TwoBoolInBoolOutLambda comp, AnalyticsValueStream ... params) {
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires parameters.");
        }
        if (params.length == 1) {
            if (params[0] instanceof BooleanValueStream) {
                return LambdaFunction.createBooleanLambdaFunction(name, comp, (BooleanValueStream)params[0]);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires boolean parameters. Incorrect param: " + params[0].getExpressionStr());
        }
        if (params.length == 2) {
            AnalyticsValueStream param1 = params[0];
            AnalyticsValueStream param2 = params[1];
            if (param1 instanceof BooleanValueStream && param2 instanceof BooleanValueStream) {
                return LambdaFunction.createBooleanLambdaFunction(name, comp, (BooleanValueStream)param1, (BooleanValueStream)param2);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires boolean parameters.");
        }
        BooleanValue[] castedParams = new BooleanValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof BooleanValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires that all parameters be single-valued if more than 2 are given.");
            }
            castedParams[i] = (BooleanValue)params[i];
        }
        return LambdaFunction.createBooleanLambdaFunction(name, comp, castedParams);
    }

    public static class OrFunction {
        public static final String name = "or";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> LogicFunction.createBitwiseFunction(name, (a, b) -> a || b, params);
    }

    public static class AndFunction {
        public static final String name = "and";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> LogicFunction.createBitwiseFunction(name, (a, b) -> a && b, params);
    }
}

