/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.solrmarc.tools.DataUtil;
import org.solrmarc.tools.PropertyUtils;

public final class Utils {
    private Utils() {
    }

    public static String join(String[] strs, String delimiter) {
        StringBuilder strb = new StringBuilder();
        for (String str : strs) {
            if (strb.length() != 0) {
                strb.append(delimiter);
            }
            strb.append(str);
        }
        return strb.toString();
    }

    public static String join(Iterable<String> strs, String delimiter) {
        StringBuilder strb = new StringBuilder();
        for (String str : strs) {
            if (strb.length() != 0) {
                strb.append(delimiter);
            }
            strb.append(str);
        }
        return strb.toString();
    }

    @Deprecated
    public static String cleanDate(String date) {
        return DataUtil.cleanDate(date);
    }

    @Deprecated
    public static String cleanData(String origStr) {
        return DataUtil.cleanData(origStr);
    }

    @Deprecated
    public static String removeAllTrailingCharAndPeriod(String origStr, String trailingCharsRegEx, String charsB4periodRegEx) {
        return DataUtil.removeAllTrailingCharAndPeriod(origStr, trailingCharsRegEx, charsB4periodRegEx);
    }

    @Deprecated
    public static String removeTrailingCharAndPeriod(String origStr, String trailingCharsRegEx, String charsB4periodRegEx) {
        return DataUtil.removeTrailingCharAndPeriod(origStr, trailingCharsRegEx, charsB4periodRegEx);
    }

    @Deprecated
    public static String removeTrailingChar(String origStr, String charsToReplaceRegEx) {
        return DataUtil.removeTrailingChar(origStr, charsToReplaceRegEx);
    }

    @Deprecated
    public static String removeTrailingPeriod(String origStr, String precedingCharsRegEx) {
        return DataUtil.removeTrailingPeriod(origStr, precedingCharsRegEx);
    }

    @Deprecated
    public static String removeOuterBrackets(String origStr) {
        return DataUtil.removeOuterBrackets(origStr);
    }

    public static String calcTime(long totalTime) {
        DecimalFormat timeFormat = new DecimalFormat("00.00");
        return totalTime / 60000L + ":" + timeFormat.format(totalTime % 60000L / 1000L);
    }

    public static boolean isNumber(String number) {
        boolean isNumber;
        try {
            Integer.parseInt(number);
            isNumber = true;
        }
        catch (NumberFormatException nfe) {
            isNumber = false;
        }
        return isNumber;
    }

    public static boolean containsMatch(String val, String pattern) {
        String rep = val.replaceFirst(pattern, "###match###");
        return !rep.equals(val);
    }

    public static boolean setItemContains(Collection<String> set, String pattern) {
        if (set.isEmpty()) {
            return false;
        }
        for (String value : set) {
            if (!Utils.containsMatch(value, pattern)) continue;
            return true;
        }
        return false;
    }

    public static String join(Set<String> set, String separator) {
        Iterator<String> iter = set.iterator();
        StringBuilder result = new StringBuilder("");
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static Set<String> trimNearDuplicates(Set<String> locations) {
        if ((locations = DataUtil.cleanData(locations)).size() <= 1) {
            return locations;
        }
        Object[] locArr = locations.toArray();
        int size = locArr.length;
        for (int i = 0; i < size; ++i) {
            boolean copyStrI = true;
            for (int j = 0; j < size; ++j) {
                if (i == j || !locArr[j].toString().contains(locArr[i].toString())) continue;
                copyStrI = false;
                break;
            }
            if (copyStrI) continue;
            locations.remove(locArr[i]);
        }
        return locations;
    }

    public static final boolean isRightToLeftLanguage(String langcode) {
        return langcode.equals("ara") || langcode.equals("per") || langcode.equals("urd") || langcode.equals("heb") || langcode.equals("yid") || langcode.equals("lad") || langcode.equals("jpr") || langcode.equals("jrb");
    }

    public static final int getIxUnescapedOpenParen(String str) {
        if (str.startsWith("(")) {
            return 0;
        }
        Pattern p = Pattern.compile(".*[^\\\\](\\().*");
        Matcher m = p.matcher(str);
        if (m.matches()) {
            return m.start(1);
        }
        return -1;
    }

    public static final int getIxUnescapedComma(String str) {
        if (str.startsWith(",")) {
            return 0;
        }
        Pattern p = Pattern.compile(".*[^\\\\](,).*");
        Matcher m = p.matcher(str);
        if (m.matches()) {
            return m.start(1);
        }
        return -1;
    }

    public static final Set<String> getPrefixedVals(Set<String> valueSet, String prefix) {
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>();
        if (!valueSet.isEmpty()) {
            for (String aValueSet : valueSet) {
                String value;
                String s = Utils.removePrefix(aValueSet, prefix);
                if (s == null || (value = s.trim()) == null || value.length() == 0) continue;
                resultSet.add(value);
            }
        }
        return resultSet;
    }

    public static final String removePrefix(String value, String prefix) {
        if (value.startsWith(prefix) && (value = value.substring(prefix.length())) != null && value.length() != 0) {
            return value;
        }
        return null;
    }

    @Deprecated
    public static Set<String> returnValidISBNs(Set<String> candidates) {
        LinkedHashSet<String> isbnSet = new LinkedHashSet<String>();
        Pattern p10 = Pattern.compile("^\\d{9}[\\dX].*");
        Pattern p13 = Pattern.compile("^(978|979)\\d{9}[X\\d].*");
        Pattern p13any = Pattern.compile("^\\d{12}[X\\d].*");
        for (String candidate : candidates) {
            String value = candidate.trim();
            if (p13.matcher(value).matches()) {
                isbnSet.add(value.substring(0, 13));
                continue;
            }
            if (!p10.matcher(value).matches() || p13any.matcher(value).matches()) continue;
            isbnSet.add(value.substring(0, 10));
        }
        return isbnSet;
    }

    public static final Set<String> getAllSubfields(Record record, String[] tags) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List varFlds = record.getVariableFields(tags);
        for (VariableField vf : varFlds) {
            StringBuilder buffer = new StringBuilder(500);
            DataField df = (DataField)vf;
            if (df != null) {
                List subfields = df.getSubfields();
                for (Subfield sf : subfields) {
                    if (buffer.length() > 0) {
                        buffer.append(" ").append(sf.getData());
                        continue;
                    }
                    buffer.append(sf.getData());
                }
            }
            if (buffer.length() <= 0) continue;
            result.add(buffer.toString());
        }
        return result;
    }

    public static final String getSubfieldData(DataField df, char code) {
        Subfield sf;
        String result = null;
        if (df != null && (sf = df.getSubfield(code)) != null && sf.getData() != null) {
            result = sf.getData();
        }
        return result;
    }

    public static final List<String> getSubfieldStrings(DataField df, char code) {
        List listSubcode = df.getSubfields(code);
        ArrayList<String> vals = new ArrayList<String>(listSubcode.size());
        for (Subfield s : listSubcode) {
            vals.add(s.getData());
        }
        return vals;
    }

    public static char foldDiacriticLatinChar(char c) {
        switch (c) {
            case '\u0181': {
                return 'B';
            }
            case '\u0182': {
                return 'B';
            }
            case '\u0187': {
                return 'C';
            }
            case '\u0110': {
                return 'D';
            }
            case '\u018a': {
                return 'D';
            }
            case '\u018b': {
                return 'D';
            }
            case '\u0191': {
                return 'F';
            }
            case '\u0193': {
                return 'G';
            }
            case '\u01e4': {
                return 'G';
            }
            case '\u0126': {
                return 'H';
            }
            case '\u0197': {
                return 'I';
            }
            case '\u0198': {
                return 'K';
            }
            case '\u0141': {
                return 'L';
            }
            case '\u019d': {
                return 'N';
            }
            case '\u0220': {
                return 'N';
            }
            case '\u00d8': {
                return 'O';
            }
            case '\u019f': {
                return 'O';
            }
            case '\u01fe': {
                return 'O';
            }
            case '\u01a4': {
                return 'P';
            }
            case '\u0166': {
                return 'T';
            }
            case '\u01ac': {
                return 'T';
            }
            case '\u01ae': {
                return 'T';
            }
            case '\u01b2': {
                return 'V';
            }
            case '\u01b3': {
                return 'Y';
            }
            case '\u01b5': {
                return 'Z';
            }
            case '\u0224': {
                return 'Z';
            }
            case '\u0180': {
                return 'b';
            }
            case '\u0183': {
                return 'b';
            }
            case '\u0253': {
                return 'b';
            }
            case '\u0188': {
                return 'c';
            }
            case '\u0255': {
                return 'c';
            }
            case '\u0111': {
                return 'd';
            }
            case '\u018c': {
                return 'd';
            }
            case '\u0221': {
                return 'd';
            }
            case '\u0256': {
                return 'd';
            }
            case '\u0257': {
                return 'd';
            }
            case '\u0192': {
                return 'f';
            }
            case '\u01e5': {
                return 'g';
            }
            case '\u0260': {
                return 'g';
            }
            case '\u0127': {
                return 'h';
            }
            case '\u0266': {
                return 'h';
            }
            case '\u0268': {
                return 'i';
            }
            case '\u029d': {
                return 'j';
            }
            case '\u0199': {
                return 'k';
            }
            case '\u0142': {
                return 'l';
            }
            case '\u019a': {
                return 'l';
            }
            case '\u0234': {
                return 'l';
            }
            case '\u026b': {
                return 'l';
            }
            case '\u026c': {
                return 'l';
            }
            case '\u026d': {
                return 'l';
            }
            case '\u0271': {
                return 'm';
            }
            case '\u019e': {
                return 'n';
            }
            case '\u0235': {
                return 'n';
            }
            case '\u0272': {
                return 'n';
            }
            case '\u0273': {
                return 'n';
            }
            case '\u00f8': {
                return 'o';
            }
            case '\u01ff': {
                return 'o';
            }
            case '\u01a5': {
                return 'p';
            }
            case '\u02a0': {
                return 'q';
            }
            case '\u027c': {
                return 'r';
            }
            case '\u027d': {
                return 'r';
            }
            case '\u0282': {
                return 's';
            }
            case '\u0167': {
                return 't';
            }
            case '\u01ab': {
                return 't';
            }
            case '\u01ad': {
                return 't';
            }
            case '\u0236': {
                return 't';
            }
            case '\u0288': {
                return 't';
            }
            case '\u028b': {
                return 'v';
            }
            case '\u01b4': {
                return 'y';
            }
            case '\u01b6': {
                return 'z';
            }
            case '\u0225': {
                return 'z';
            }
            case '\u0290': {
                return 'z';
            }
            case '\u0291': {
                return 'z';
            }
        }
        return '\u0000';
    }

    @Deprecated
    public static String getProperty(Properties props, String propname, String defVal) {
        return PropertyUtils.getProperty(props, propname, defVal);
    }

    @Deprecated
    public static Properties loadProperties(String[] propertyPaths, String propertyFileName) {
        return PropertyUtils.loadProperties(propertyPaths, propertyFileName);
    }
}

