/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.solrmarc.index.indexer.IndexerSpecException;

public class PropertyUtils {
    protected static final Logger logger = Logger.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static String getProperty(Properties props, String propname) {
        return PropertyUtils.getProperty(props, propname, null);
    }

    public static String getProperty(Properties props, String propname, String defVal) {
        String prop = System.getProperty(propname);
        if (prop != null) {
            return prop;
        }
        if (props != null && (prop = props.getProperty(propname)) != null) {
            return prop;
        }
        return defVal;
    }

    public static Properties loadProperties(String[] propertyPaths, String propertyFileName) {
        return PropertyUtils.loadProperties(propertyPaths, propertyFileName, false, null, null);
    }

    public static Properties loadProperties(String[] propertyPaths, String propertyFileName, boolean showName) {
        return PropertyUtils.loadProperties(propertyPaths, propertyFileName, showName, null, null);
    }

    public static Properties loadProperties(String[] propertyPaths, String propertyFileName, String[] filenameReturn) {
        return PropertyUtils.loadProperties(propertyPaths, propertyFileName, false, null, filenameReturn);
    }

    public static Properties loadProperties(String fullFilenameURLStr) {
        InputStream in = PropertyUtils.getPropertyFileInputStream(fullFilenameURLStr);
        String errmsg = "Fatal error: Unable to find specified properties file: " + fullFilenameURLStr;
        Properties props = new Properties();
        try {
            if (fullFilenameURLStr.endsWith(".xml") || fullFilenameURLStr.endsWith(".XML")) {
                props.loadFromXML(in);
            } else {
                props.load(new InputStreamReader(in, "UTF-8"));
            }
            in.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errmsg);
        }
        return props;
    }

    public static Properties loadProperties(String[] propertyPaths, String propertyFileName, boolean showName, String filenameProperty, String[] inputSourceReturn) {
        String[] inputStreamSource = new String[]{null};
        InputStream in = PropertyUtils.getPropertyFileInputStream(propertyPaths, propertyFileName, showName, inputStreamSource);
        Properties props = new Properties();
        try {
            if (propertyFileName.endsWith(".xml") || propertyFileName.endsWith(".XML")) {
                props.loadFromXML(in);
            } else {
                props.load(new InputStreamReader(in, "UTF-8"));
            }
            in.close();
            if (filenameProperty != null && inputStreamSource[0] != null) {
                File tmpFile = new File(inputStreamSource[0]);
                props.setProperty(filenameProperty, tmpFile.getParent());
            }
            if (inputSourceReturn != null && inputStreamSource[0] != null) {
                inputSourceReturn[0] = inputStreamSource[0];
            }
        }
        catch (InvalidPropertiesFormatException ipfe) {
            String errmsg = "Fatal error: Illegal format in specified properties file: " + propertyFileName + " : " + ipfe.getMessage();
            throw new IllegalArgumentException(errmsg);
        }
        catch (FileNotFoundException fnfe) {
            String errmsg = "Fatal error: Unable to find specified properties file: " + propertyFileName + " : " + fnfe.getMessage();
            throw new IllegalArgumentException(errmsg);
        }
        catch (IOException ioe) {
            String errmsg = "Fatal error: Error reading from specified properties file: " + propertyFileName + " : " + ioe.getMessage();
            throw new IllegalArgumentException(errmsg);
        }
        return props;
    }

    public static InputStream getPropertyFileInputStream(String[] propertyPaths, String propertyFileName) {
        return PropertyUtils.getPropertyFileInputStream(propertyPaths, propertyFileName, false);
    }

    public static InputStream getPropertyFileInputStream(String[] propertyPaths, String propertyFileName, boolean showName) {
        return PropertyUtils.getPropertyFileInputStream(propertyPaths, propertyFileName, false, null);
    }

    public static InputStream getPropertyFileInputStream(String propertyFileURLStr) {
        InputStream in = null;
        String errmsg = "Fatal error: Unable to open specified properties file: " + propertyFileURLStr;
        try {
            URL url = new URL(propertyFileURLStr);
            in = url.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errmsg);
        }
        return in;
    }

    public static InputStream getPropertyFileInputStream(String[] propertyPaths, String propertyFileName, boolean showName, String[] inputSource) {
        String fullPropertyFileURLStr = PropertyUtils.getPropertyFileAbsoluteURL(propertyPaths, propertyFileName, showName, inputSource);
        return PropertyUtils.getPropertyFileInputStream(fullPropertyFileURLStr);
    }

    public static String getPropertyFileAbsoluteURL(String[] propertyPaths, String propertyFileName, boolean showName, String[] inputSource) {
        File propertyFileToReturn = null;
        String fullPathNameToReturn = null;
        int numFound = 0;
        File propertyFile = new File(propertyFileName);
        if (propertyFile.isAbsolute() && propertyFile.exists() && propertyFile.isFile() && propertyFile.canRead()) {
            numFound = 1;
            propertyFileToReturn = propertyFile;
            try {
                fullPathNameToReturn = propertyFile.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (propertyPaths != null && propertyPaths.length != 0) {
            for (String pathPrefix : propertyPaths) {
                propertyFile = new File(pathPrefix, propertyFileName);
                if (propertyFile.exists() && propertyFile.isFile() && propertyFile.canRead()) {
                    if (inputSource != null && inputSource.length >= 1) {
                        inputSource[0] = propertyFile.getAbsolutePath();
                    }
                    if (propertyFileToReturn == null) {
                        propertyFileToReturn = propertyFile;
                    } else {
                        logger.debug((Object)("Skipped opening file: " + propertyFile.getAbsolutePath()));
                    }
                    ++numFound;
                    continue;
                }
                logger.debug((Object)("looked for file: " + propertyFile.getAbsolutePath()));
            }
        }
        if (propertyFileToReturn != null) {
            try {
                fullPathNameToReturn = propertyFileToReturn.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (numFound == 0) {
            String errmsg = "Fatal error: Unable to find specified properties file: " + propertyFileName;
            logger.error((Object)errmsg);
            throw new IndexerSpecException(IndexerSpecException.eErrorSeverity.FATAL, errmsg);
        }
        if (numFound == 1) {
            logger.debug((Object)("Opening file: " + propertyFileToReturn.getAbsolutePath()));
        } else if (numFound > 1) {
            logger.info((Object)("Opening file (instead of " + (numFound - 1) + " other options): " + propertyFileToReturn.getAbsolutePath()));
        }
        return fullPathNameToReturn;
    }

    public static String readStreamIntoString(InputStream stream) throws IOException {
        int length;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[4096];
        while ((length = in.read(chars)) > 0) {
            sb.append(chars, 0, length);
        }
        return sb.toString();
    }

    public static File findFirstExistingFile(String[] homeDirStrs, String indexSpec) {
        String[] inputSource = new String[1];
        URL fileURL = null;
        try {
            fileURL = new URL(PropertyUtils.getPropertyFileAbsoluteURL(homeDirStrs, indexSpec, true, inputSource));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        File firstExisting = new File(fileURL.getFile());
        return firstExisting;
    }
}

