/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.tools;

import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.tools.Utils;

public class DataUtil {
    private static final String TWO_DIGIT_PREFIXES = "(20|19|18|17|16|15|14|13|12|11|10)";
    private static final Pattern FOUR_DIGIT_PATTERN_BRACES = Pattern.compile("\\[[12]\\d{3,3}\\]");
    private static final Pattern FOUR_DIGIT_PATTERN_ONE_BRACE = Pattern.compile("\\[[12]\\d{3,3}");
    private static final Pattern FOUR_DIGIT_PATTERN_STARTING_WITH_1_2 = Pattern.compile("(20|19|18|17|16|15|14|13|12|11|10)[0-9][0-9]");
    private static final Pattern FOUR_DIGIT_PATTERN_OTHER_1 = Pattern.compile("l\\d{3,3}");
    private static final Pattern FOUR_DIGIT_PATTERN_OTHER_2 = Pattern.compile("\\[19\\]\\d{2,2}");
    private static final Pattern FOUR_DIGIT_PATTERN_OTHER_3 = Pattern.compile("(20|19|18|17|16|15|14|13|12|11|10)[0-9][-?0-9]");
    private static final Pattern FOUR_DIGIT_PATTERN_OTHER_4 = Pattern.compile("i.e. (20|19|18|17|16|15|14|13|12|11|10)[0-9][0-9]");
    private static final Pattern BC_DATE_PATTERN = Pattern.compile("[0-9]+ [Bb][.]?[Cc][.]?");
    private static final Pattern FOUR_DIGIT_PATTERN = Pattern.compile("\\d{4,4}");
    protected static Logger logger = Logger.getLogger((String)DataUtil.class.getName());
    private static Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static Pattern PUNCT_OR_SPACE = Pattern.compile("[ \\p{Punct}]+", 256);

    public static String cleanDate(String date) {
        String tmp;
        Matcher matcher_braces = FOUR_DIGIT_PATTERN_BRACES.matcher(date);
        Matcher matcher_one_brace = FOUR_DIGIT_PATTERN_ONE_BRACE.matcher(date);
        Matcher matcher_start_with_1_2 = FOUR_DIGIT_PATTERN_STARTING_WITH_1_2.matcher(date);
        Matcher matcher_l_plus_three_digits = FOUR_DIGIT_PATTERN_OTHER_1.matcher(date);
        Matcher matcher_bracket_19_plus_two_digits = FOUR_DIGIT_PATTERN_OTHER_2.matcher(date);
        Matcher matcher_three_digits_plus_unk = FOUR_DIGIT_PATTERN_OTHER_3.matcher(date);
        Matcher matcher_ie_date = FOUR_DIGIT_PATTERN_OTHER_4.matcher(date);
        Matcher matcher = FOUR_DIGIT_PATTERN.matcher(date);
        Matcher matcher_bc_date = BC_DATE_PATTERN.matcher(date);
        String cleanDate = null;
        if (matcher_braces.find()) {
            cleanDate = matcher_braces.group();
            cleanDate = DataUtil.removeOuterBrackets(cleanDate);
            if (matcher.find() && !(tmp = matcher.group()).equals(cleanDate)) {
                tmp = "" + tmp;
            }
        } else if (matcher_ie_date.find()) {
            cleanDate = matcher_ie_date.group().replaceAll("i.e. ", "");
        } else if (matcher_one_brace.find()) {
            cleanDate = matcher_one_brace.group();
            cleanDate = DataUtil.removeOuterBrackets(cleanDate);
            if (matcher.find() && !(tmp = matcher.group()).equals(cleanDate)) {
                tmp = "" + tmp;
            }
        } else if (matcher_bc_date.find()) {
            cleanDate = null;
        } else if (matcher_start_with_1_2.find()) {
            cleanDate = matcher_start_with_1_2.group();
        } else if (matcher_l_plus_three_digits.find()) {
            cleanDate = matcher_l_plus_three_digits.group().replaceAll("l", "1");
        } else if (matcher_bracket_19_plus_two_digits.find()) {
            cleanDate = matcher_bracket_19_plus_two_digits.group().replaceAll("\\[", "").replaceAll("\\]", "");
        } else if (matcher_three_digits_plus_unk.find()) {
            cleanDate = matcher_three_digits_plus_unk.group().replaceAll("[-?]", "0");
        }
        if (cleanDate != null) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
            String thisYear = dateFormat.format(calendar.getTime());
            try {
                if (Integer.parseInt(cleanDate) > Integer.parseInt(thisYear) + 1) {
                    cleanDate = null;
                }
            }
            catch (NumberFormatException nfe) {
                cleanDate = null;
            }
        }
        if (cleanDate != null) {
            logger.debug((Object)("Date : " + date + " mapped to : " + cleanDate));
        } else {
            logger.debug((Object)("No Date match: " + date));
        }
        return cleanDate;
    }

    public static String cleanData(String origStr) {
        String prevResult;
        String currResult = origStr;
        do {
            prevResult = currResult;
            currResult = currResult.trim();
            if ((currResult = currResult.replaceAll(" *([,/;:])$", "")).endsWith(".") && !currResult.matches(".*[JS]r\\.$")) {
                if (currResult.matches(".*\\w\\w\\.$")) {
                    currResult = currResult.substring(0, currResult.length() - 1);
                } else if (currResult.matches(".*\\p{L}\\p{L}\\.$")) {
                    currResult = currResult.substring(0, currResult.length() - 1);
                } else if (currResult.matches(".*\\w\\p{InCombiningDiacriticalMarks}?\\w\\p{InCombiningDiacriticalMarks}?\\.$")) {
                    currResult = currResult.substring(0, currResult.length() - 1);
                } else if (currResult.matches(".*\\p{Punct}\\.$")) {
                    currResult = currResult.substring(0, currResult.length() - 1);
                }
            }
            if ((currResult = DataUtil.removeOuterBrackets(currResult)).length() != 0) continue;
            return currResult;
        } while (!currResult.equals(prevResult));
        return currResult;
    }

    public static Set<String> cleanData(Set<String> values) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String entry : values) {
            String cleaned = DataUtil.cleanData(entry);
            result.add(cleaned);
        }
        return result;
    }

    public static String removeAllTrailingCharAndPeriod(String origStr, String trailingCharsRegEx, String charsB4periodRegEx) {
        String prevResult;
        if (origStr == null) {
            return null;
        }
        String currResult = origStr;
        do {
            prevResult = currResult;
            if ((currResult = DataUtil.removeTrailingCharAndPeriod(currResult.trim(), trailingCharsRegEx, charsB4periodRegEx)).length() != 0) continue;
            return currResult;
        } while (!currResult.equals(prevResult));
        return currResult;
    }

    public static String removeTrailingCharAndPeriod(String origStr, String trailingCharsRegEx, String charsB4periodRegEx) {
        if (origStr == null) {
            return null;
        }
        String result = DataUtil.removeTrailingChar(origStr, trailingCharsRegEx);
        result = DataUtil.removeTrailingPeriod(result, charsB4periodRegEx);
        return result;
    }

    public static String removeTrailingChar(String origStr, String charsToReplaceRegEx) {
        if (origStr == null) {
            return origStr;
        }
        return origStr.trim().replaceAll(charsToReplaceRegEx + "$", "");
    }

    public static String removeTrailingPeriod(String origStr, String precedingCharsRegEx) {
        if (origStr == null) {
            return origStr;
        }
        String result = origStr.trim();
        if (result.endsWith(".") && result.matches(".*" + precedingCharsRegEx + "\\.$")) {
            result = result.substring(0, result.length() - 1).trim();
        }
        return result;
    }

    public static String removeOuterBrackets(String origStr) {
        if (origStr == null || origStr.length() == 0) {
            return origStr;
        }
        String result = origStr.trim();
        if (result.length() > 0) {
            boolean openBracketFirst = result.charAt(0) == '[';
            boolean closeBracketLast = result.endsWith("]");
            if (openBracketFirst && closeBracketLast && result.indexOf(91, 1) == -1 && result.lastIndexOf(93, result.length() - 2) == -1) {
                result = result.substring(1, result.length() - 1);
            } else if (openBracketFirst && result.indexOf(93) == -1) {
                result = result.substring(1);
            } else if (closeBracketLast && result.indexOf(91) == -1) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result.trim();
    }

    public static String toTitleCase(String s) {
        String ACTIONABLE_DELIMITERS = " .-/";
        String QUESTIONABLE_DELIMITERS = "'";
        boolean hasNoLowerCase = true;
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            hasNoLowerCase = false;
        }
        StringBuilder sb = new StringBuilder();
        int countSinceActionable = 0;
        int prevChar = 32;
        for (char c : s.toCharArray()) {
            boolean cIsUpper = Character.isUpperCase(c);
            boolean cIsLower = Character.isLowerCase(c);
            boolean curActionable = " .-/".indexOf(c) >= 0;
            boolean prevActionable = " .-/".indexOf(prevChar) >= 0;
            boolean prevQuestionable = "'".indexOf(prevChar) >= 0;
            boolean toUpper = false;
            boolean toLower = false;
            if (prevActionable && cIsLower) {
                toUpper = true;
            } else if (prevQuestionable && cIsLower && countSinceActionable <= 2) {
                toUpper = true;
            } else if (hasNoLowerCase && cIsUpper && countSinceActionable >= 1) {
                toLower = true;
            }
            int n = countSinceActionable = curActionable ? 0 : countSinceActionable + 1;
            char newC = toUpper ? Character.toUpperCase(c) : (toLower ? Character.toLowerCase(c) : c);
            sb.append(newC);
            prevChar = c;
        }
        return sb.toString();
    }

    public static EnumSet<FieldFormatter.eCleanVal> getCleanValForParam(String params) {
        EnumSet<FieldFormatter.eCleanVal> result = EnumSet.noneOf(FieldFormatter.eCleanVal.class);
        for (FieldFormatter.eCleanVal cleanVal : EnumSet.allOf(FieldFormatter.eCleanVal.class)) {
            if (!params.contains(cleanVal.toString())) continue;
            result.add(cleanVal);
        }
        if (params.contains("titleSortUpper")) {
            result.addAll(EnumSet.of(FieldFormatter.eCleanVal.CLEAN_EACH, FieldFormatter.eCleanVal.STRIP_ACCCENTS, FieldFormatter.eCleanVal.STRIP_ALL_PUNCT, FieldFormatter.eCleanVal.TO_UPPER, FieldFormatter.eCleanVal.STRIP_INDICATOR));
        }
        if (params.contains("titleSortLower")) {
            result.addAll(EnumSet.of(FieldFormatter.eCleanVal.CLEAN_EACH, FieldFormatter.eCleanVal.STRIP_ACCCENTS, FieldFormatter.eCleanVal.STRIP_ALL_PUNCT, FieldFormatter.eCleanVal.TO_LOWER, FieldFormatter.eCleanVal.STRIP_INDICATOR));
        }
        if (params.matches(".*clean([^E].*|$)")) {
            result.addAll(EnumSet.of(FieldFormatter.eCleanVal.CLEAN_EACH, FieldFormatter.eCleanVal.CLEAN_END));
        }
        return result;
    }

    public static String cleanByVal(String input, EnumSet<FieldFormatter.eCleanVal> cleanVal) {
        String str;
        String string = str = cleanVal.contains((Object)FieldFormatter.eCleanVal.CLEAN_EACH) ? DataUtil.cleanData(input) : input;
        if (!(cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_ACCCENTS) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_ALL_PUNCT) || cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_LOWER) || cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_UPPER) || cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_TITLECASE) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_1) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR_2) || cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_INDICATOR))) {
            return str;
        }
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_ACCCENTS)) {
            str = DataUtil.stripAccents(str);
        }
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.STRIP_ALL_PUNCT)) {
            str = DataUtil.stripAllPunct(str);
        }
        if (!cleanVal.contains((Object)FieldFormatter.eCleanVal.UNTRIMMED)) {
            str = str.trim();
        }
        if (cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_LOWER)) {
            str = str.toLowerCase();
        } else if (cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_UPPER)) {
            str = str.toUpperCase();
        } else if (cleanVal.contains((Object)FieldFormatter.eCleanVal.TO_TITLECASE)) {
            str = DataUtil.toTitleCase(str);
        }
        return str;
    }

    public static String stripAllPunct(String str) {
        String str2;
        String str1 = str.replaceAll("( |\\p{Punct})+", " ");
        if (str1.equals(str2 = PUNCT_OR_SPACE.matcher(str).replaceAll(" "))) {
            str = str1;
        } else {
            str = str2;
            str = str.replaceAll("( |\\p{Punct})+", " ");
        }
        return str;
    }

    public static String stripAccents(String str) {
        str = ACCENTS.matcher(Normalizer.normalize(str, Normalizer.Form.NFD)).replaceAll("");
        StringBuilder folded = new StringBuilder();
        boolean replaced = false;
        for (char c : str.toCharArray()) {
            char newc = Utils.foldDiacriticLatinChar(c);
            if (newc != '\u0000') {
                folded.append(newc);
                replaced = true;
                continue;
            }
            folded.append(c);
        }
        if (replaced) {
            str = folded.toString();
        }
        return str;
    }
}

