/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.solr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.solr.SolrProxy;

public class StdOutProxy
extends SolrProxy {
    PrintStream output;

    public StdOutProxy(PrintStream out) {
        this.output = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDoc(RecordAndDoc recdoc) {
        PrintStream printStream = this.output;
        synchronized (printStream) {
            SolrInputDocument inputDoc = recdoc.getDoc();
            ArrayList fNames = new ArrayList();
            fNames.addAll(inputDoc.getFieldNames());
            Collections.sort(fNames);
            String id = inputDoc.getFieldValue("id") != null ? inputDoc.getFieldValue("id").toString() : "<no id>";
            for (String fieldName : fNames) {
                Collection values = inputDoc.getFieldValues(fieldName);
                if (values == null) continue;
                for (Object val : values) {
                    this.output.print(id + " : " + fieldName + " = " + (val != null ? val.toString() : "[null]") + "\n");
                }
            }
            return 1;
        }
    }

    @Override
    public int addDocs(Collection<RecordAndDoc> recdocQ) {
        int num = 0;
        for (RecordAndDoc recdoc : recdocQ) {
            num += this.addDoc(recdoc);
        }
        return num;
    }

    @Override
    public void commit(boolean optimize) {
        this.output.flush();
    }

    @Override
    public void delete(String id) {
    }

    @Override
    public QueryResponse query(SolrQuery params) {
        return null;
    }
}

