/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.solr.SolrRuntimeException;

public class SolrServerProxy
extends SolrProxy {
    final SolrServer solrserver;

    public SolrServerProxy(SolrServer solrserver) {
        this.solrserver = solrserver;
    }

    public SolrServerProxy(Object httpsolrserver) {
        this.solrserver = (SolrServer)httpsolrserver;
    }

    @Override
    public int addDoc(RecordAndDoc recdoc) {
        int num = 0;
        try {
            SolrInputDocument inputDoc = recdoc.getDoc();
            UpdateResponse resp = this.solrserver.add(inputDoc);
            int status = resp.getStatus();
            return ++num;
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (SolrServerException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IOException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    @Override
    public int addDocs(Collection<RecordAndDoc> recdocQ) {
        int num = 0;
        try {
            ArrayList<SolrInputDocument> docQ = new ArrayList<SolrInputDocument>(recdocQ.size());
            for (RecordAndDoc recdoc : recdocQ) {
                docQ.add(recdoc.getDoc());
            }
            UpdateResponse resp = this.solrserver.add(docQ);
            NamedList respresp = resp.getResponse();
            int size = respresp.size();
            return num += docQ.size();
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrException", e);
        }
        catch (SolrServerException e) {
            throw new SolrRuntimeException("SolrServerException", e);
        }
        catch (IOException e) {
            throw new SolrRuntimeException("IOException", e);
        }
    }

    @Override
    public void commit(boolean optimize) {
        try {
            if (optimize) {
                this.solrserver.optimize();
            } else {
                this.solrserver.commit();
            }
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrException", e);
        }
        catch (SolrServerException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IOException e) {
            throw new SolrRuntimeException("IOException", e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.solrserver.deleteById(id);
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrException", e);
        }
        catch (SolrServerException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IOException e) {
            throw new SolrRuntimeException("IOException", e);
        }
    }

    @Override
    public QueryResponse query(SolrQuery params) {
        try {
            return this.solrserver.query((SolrParams)params);
        }
        catch (SolrServerException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }
}

