/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.solrmarc.driver.Boot;
import org.solrmarc.solr.SolrClientProxy;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.solr.SolrRuntimeException;
import org.solrmarc.solr.SolrServerProxy;

public class SolrCoreLoader {
    public static Logger logger = Logger.getLogger(SolrCoreLoader.class);
    public static final String[] defaultSolrJClassnames = new String[]{"org.apache.solr.client.solrj.impl.HttpSolrClient$Builder", "org.apache.solr.client.solrj.impl.HttpSolrClient", "org.apache.solr.client.solrj.impl.HttpSolrServer", "org.apache.solr.client.solrj.impl.CommonsHttpSolrServer"};

    public static SolrProxy loadRemoteSolrServer(String solrHostUpdateURL, String fullClassName, boolean useBinaryRequestHandler) {
        URL pingURL;
        SolrProxy solrProxy = null;
        String urlString = solrHostUpdateURL.replaceAll("[/\\\\]update$", "");
        try {
            pingURL = new URL(urlString + "/admin/ping");
        }
        catch (MalformedURLException e2) {
            throw new SolrRuntimeException("Malformed URL for solr server " + urlString, e2);
        }
        boolean statusOK = false;
        BufferedReader pingStream = null;
        try {
            String line;
            pingStream = new BufferedReader(new InputStreamReader(pingURL.openStream()));
            logger.debug((Object)("Pinging Solr at URL:  " + pingURL));
            boolean dotsShown = false;
            while ((line = pingStream.readLine()) != null) {
                if (line.matches(".*\"status\">OK<.*") || line.matches(".*\"status\":\"OK\".*")) {
                    logger.debug((Object)("    " + line));
                    statusOK = true;
                    dotsShown = false;
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("    " + line));
                    continue;
                }
                if (!logger.isDebugEnabled() || dotsShown) continue;
                logger.debug((Object)"    ...");
                dotsShown = true;
            }
        }
        catch (IOException e1) {
            throw new SolrRuntimeException("Error connecting to solr server for ping " + urlString, e1);
        }
        finally {
            if (pingStream != null) {
                try {
                    pingStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!statusOK) {
            throw new SolrRuntimeException("Solr reports not OK " + urlString);
        }
        try {
            Class<?> superclass;
            Class<?> httpsolrserverClass = null;
            if (fullClassName != null && fullClassName.length() > 0) {
                httpsolrserverClass = Boot.classForName(fullClassName);
            } else {
                for (String classname : defaultSolrJClassnames) {
                    try {
                        httpsolrserverClass = Boot.classForName(classname);
                        logger.debug((Object)("Found Solrj class " + classname));
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug((Object)("Didn't find class " + classname));
                    }
                }
                if (httpsolrserverClass == null) {
                    throw new SolrRuntimeException("Error finding class solrj client while dynamically loading solrj");
                }
            }
            Constructor<?> httpsolrserverConst = httpsolrserverClass.getDeclaredConstructor(String.class);
            Object httpsolrserver = httpsolrserverConst.newInstance(urlString);
            if (httpsolrserverClass.getName().endsWith("Builder")) {
                Method buildsolrserver = httpsolrserverClass.getMethod("build", new Class[0]);
                httpsolrserver = buildsolrserver.invoke(httpsolrserver, new Object[0]);
            }
            if ((superclass = httpsolrserver.getClass().getSuperclass()).getName().endsWith(".SolrServer")) {
                solrProxy = new SolrServerProxy(httpsolrserver);
                return solrProxy;
            }
            if (superclass.getName().endsWith(".SolrClient") || superclass.getName().endsWith(".BaseHttpSolrClient")) {
                solrProxy = new SolrClientProxy(httpsolrserver);
                return solrProxy;
            }
        }
        catch (ClassNotFoundException e) {
            throw new SolrRuntimeException("Error finding class while dynamically loading solrj", e);
        }
        catch (NoClassDefFoundError e) {
            throw new SolrRuntimeException("Error finding class while dynamically loading solrj", e);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new SolrRuntimeException("Error finding solrj constructor with one String parameter", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new SolrRuntimeException("Error invoking solrj constructor with one String parameter", e);
        }
        throw new SolrRuntimeException("Error Specified solrj class name, found, but it isnt a SolrServer or a SolrClient");
    }
}

