/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.solr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.solrmarc.driver.RecordAndDoc;
import org.solrmarc.solr.SolrProxy;
import org.solrmarc.solr.SolrRuntimeException;

public class SolrClientProxy
extends SolrProxy {
    Object solrclient;
    Method addDoc;
    Method addDocs;
    Method commit;
    Method optimize;
    Method delete;
    Method query;

    public SolrClientProxy(Object httpsolrclient) {
        this.solrclient = httpsolrclient;
        try {
            this.addDoc = SolrClientProxy.getMethod(this.solrclient, "add", SolrInputDocument.class);
            this.addDocs = SolrClientProxy.getMethod(this.solrclient, "add", Collection.class);
            this.commit = SolrClientProxy.getMethod(this.solrclient, "commit", new Class[0]);
            this.optimize = SolrClientProxy.getMethod(this.solrclient, "optimize", new Class[0]);
            this.delete = SolrClientProxy.getMethod(this.solrclient, "deleteById", String.class);
            this.query = SolrClientProxy.getMethod(this.solrclient, "query", SolrParams.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    private static Method getMethod(Object solrclient, String methodName, Class<?> ... parmClasses) throws NoSuchMethodException, SecurityException {
        Class<?> theClazz = solrclient.getClass();
        Method result = null;
        do {
            try {
                result = theClazz.getDeclaredMethod(methodName, parmClasses);
            }
            catch (NoSuchMethodException e) {
                if (theClazz == Object.class) {
                    throw e;
                }
                theClazz = theClazz.getSuperclass();
            }
        } while (result == null);
        return result;
    }

    @Override
    public int addDoc(RecordAndDoc recDoc) {
        int num = 0;
        try {
            SolrInputDocument inputDoc = recDoc.getDoc();
            UpdateResponse resp = (UpdateResponse)this.addDoc.invoke(this.solrclient, inputDoc);
            int status = resp.getStatus();
            return ++num;
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalAccessException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalArgumentException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (InvocationTargetException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    @Override
    public int addDocs(Collection<RecordAndDoc> recdocQ) {
        int num = 0;
        try {
            ArrayList<SolrInputDocument> docQ = new ArrayList<SolrInputDocument>(recdocQ.size());
            for (RecordAndDoc recdoc : recdocQ) {
                docQ.add(recdoc.getDoc());
            }
            UpdateResponse resp = (UpdateResponse)this.addDocs.invoke(this.solrclient, docQ);
            NamedList respresp = resp.getResponse();
            int size = respresp.size();
            return num += docQ.size();
        }
        catch (SolrException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalAccessException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalArgumentException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (InvocationTargetException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    @Override
    public void commit(boolean doOptimize) {
        try {
            if (doOptimize) {
                this.optimize.invoke(this.solrclient, new Object[0]);
            } else {
                this.commit.invoke(this.solrclient, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalArgumentException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (InvocationTargetException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.delete.invoke(this.solrclient, id);
        }
        catch (IllegalAccessException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (IllegalArgumentException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        catch (InvocationTargetException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
    }

    @Override
    public QueryResponse query(SolrQuery params) {
        QueryResponse result = null;
        try {
            result = (QueryResponse)this.query.invoke(this.solrclient, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SolrRuntimeException("SolrserverException", e);
        }
        return result;
    }
}

