/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.marc;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.marc4j.MarcJsonReader;
import org.marc4j.MarcPermissiveStreamReader;
import org.marc4j.MarcReader;
import org.solrmarc.marc.MarcCombiningReader;
import org.solrmarc.marc.MarcFilteredReader;
import org.solrmarc.marc.MarcMultiplexReader;
import org.solrmarc.marc.MarcTranslatedReader;
import org.solrmarc.marc.MarcUnprettyXmlReader;
import org.solrmarc.tools.PropertyUtils;

public class SolrMarcMarcReaderFactory {
    protected boolean verbose = false;
    protected boolean inputTypeXML = false;
    protected boolean inputTypeBinary = false;
    protected boolean inputTypeJSON = false;
    protected boolean includeErrors = false;
    protected boolean permissiveReader;
    protected String defaultEncoding;
    protected boolean to_utf_8;
    protected String combineConsecutiveRecordsFields = null;
    protected String unicodeNormalize = null;
    static Logger logger = Logger.getLogger((String)SolrMarcMarcReaderFactory.class.getName());
    static SolrMarcMarcReaderFactory theFactory = new SolrMarcMarcReaderFactory();

    private SolrMarcMarcReaderFactory() {
    }

    public static SolrMarcMarcReaderFactory instance() {
        return theFactory;
    }

    public MarcReader makeReader(Properties config, String[] searchDirectories, String ... inputFilenames) {
        if (inputFilenames.length == 0) {
            return this.makeReader(config, searchDirectories, "stdin");
        }
        if (inputFilenames.length == 1) {
            return this.makeReader(config, searchDirectories, inputFilenames[0]);
        }
        ArrayList<MarcReader> readers = new ArrayList<MarcReader>();
        for (String inputFilename : inputFilenames) {
            MarcReader reader = this.makeReader(config, searchDirectories, inputFilename);
            readers.add(reader);
        }
        return new MarcMultiplexReader(readers, Arrays.asList(inputFilenames));
    }

    public MarcReader makeReader(Properties config, String[] searchDirectories, List<String> inputFilenames) {
        if (inputFilenames.size() == 0) {
            return this.makeReader(config, searchDirectories, "stdin");
        }
        if (inputFilenames.size() == 1) {
            return this.makeReader(config, searchDirectories, inputFilenames.iterator().next());
        }
        ArrayList<MarcReader> readers = new ArrayList<MarcReader>();
        for (String inputFilename : inputFilenames) {
            MarcReader reader = this.makeReader(config, searchDirectories, inputFilename);
            readers.add(reader);
        }
        return new MarcMultiplexReader(readers, inputFilenames);
    }

    public MarcReader makeReader(Properties config, String[] searchDirectories, String inputFilename) {
        BufferedInputStream is;
        if (inputFilename.equals("-") || inputFilename.equals("stdin")) {
            is = new BufferedInputStream(System.in);
        } else {
            try {
                is = new BufferedInputStream(new FileInputStream(inputFilename));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Fatal error: Exception opening InputStream: " + inputFilename));
                throw new IllegalArgumentException("Fatal error: Exception opening InputStream" + inputFilename);
            }
        }
        return this.makeReader(config, searchDirectories, is);
    }

    public MarcReader makeReader(Properties config, String[] searchDirectories, InputStream input) {
        String marcRemapRecord;
        Object reader;
        int numRead;
        this.setMarc4JProperties(config);
        this.combineConsecutiveRecordsFields = PropertyUtils.getProperty(config, "marc.combine_records");
        if (this.combineConsecutiveRecordsFields != null && this.combineConsecutiveRecordsFields.length() == 0) {
            this.combineConsecutiveRecordsFields = null;
        }
        this.permissiveReader = Boolean.parseBoolean(PropertyUtils.getProperty(config, "marc.permissive"));
        this.defaultEncoding = PropertyUtils.getProperty(config, "marc.default_encoding") != null ? PropertyUtils.getProperty(config, "marc.default_encoding").trim() : "BESTGUESS";
        this.includeErrors = Boolean.parseBoolean(PropertyUtils.getProperty(config, "marc.include_errors"));
        this.to_utf_8 = Boolean.parseBoolean(PropertyUtils.getProperty(config, "marc.to_utf_8"));
        this.unicodeNormalize = PropertyUtils.getProperty(config, "marc.unicode_normalize");
        if (this.unicodeNormalize != null) {
            this.unicodeNormalize = this.handleUnicodeNormalizeParm(this.unicodeNormalize);
        }
        InputStream is = input.markSupported() ? input : new BufferedInputStream(input);
        is.mark(20);
        byte[] buffer = new byte[15];
        try {
            numRead = is.read(buffer);
            is.reset();
        }
        catch (IOException e) {
            logger.error((Object)"Fatal error: Exception reading from InputStream");
            throw new IllegalArgumentException("Fatal error: Exception reading from InputStream");
        }
        String filestart = new String(buffer);
        this.inputTypeXML = false;
        this.inputTypeBinary = false;
        this.inputTypeJSON = false;
        if (numRead == -1 || filestart.length() == 0) {
            this.inputTypeBinary = true;
        } else if (filestart.substring(0, 5).equalsIgnoreCase("<?xml")) {
            this.inputTypeXML = true;
        } else if (filestart.startsWith("{")) {
            this.inputTypeJSON = true;
        } else if (filestart.substring(0, 5).matches("\\d\\d\\d\\d\\d")) {
            this.inputTypeBinary = true;
        } else if (filestart.contains("<?xml") || filestart.contains("<?XML")) {
            this.inputTypeXML = true;
        } else if (filestart.contains("<collection")) {
            this.inputTypeXML = true;
        } else if (filestart.contains("<record")) {
            this.inputTypeXML = true;
        } else if (filestart.contains("<!--")) {
            this.inputTypeXML = true;
        }
        if (this.inputTypeXML) {
            this.to_utf_8 = true;
            reader = new MarcUnprettyXmlReader(is);
        } else if (this.inputTypeJSON) {
            this.to_utf_8 = true;
            reader = new MarcJsonReader(is);
        } else if (this.inputTypeBinary && this.permissiveReader) {
            reader = new MarcPermissiveStreamReader(is, true, this.to_utf_8, this.defaultEncoding);
        } else if (this.inputTypeBinary) {
            reader = new MarcPermissiveStreamReader(is, false, this.to_utf_8, this.defaultEncoding);
        } else {
            logger.error((Object)"Fatal error: Unable to determine type of inputfile");
            throw new IllegalArgumentException("Fatal error: Unable to determine type of inputfile.  File starts with: " + filestart);
        }
        if (reader != null && this.combineConsecutiveRecordsFields != null) {
            String combineLeftField = PropertyUtils.getProperty(config, "marc.combine_records.left_field");
            String combineRightField = PropertyUtils.getProperty(config, "marc.combine_records.right_field");
            reader = new MarcCombiningReader((MarcReader)reader, this.combineConsecutiveRecordsFields, combineLeftField, combineRightField);
        }
        String marcIncludeIfPresent = PropertyUtils.getProperty(config, "marc.include_if_present");
        String marcIncludeIfMissing = PropertyUtils.getProperty(config, "marc.include_if_missing");
        String marcDeleteSubfields = PropertyUtils.getProperty(config, "marc.delete_subfields");
        if (marcDeleteSubfields != null && marcDeleteSubfields.equals("nomap")) {
            marcDeleteSubfields = null;
        }
        if ((marcRemapRecord = PropertyUtils.getProperty(config, "marc.reader.remap")) != null && marcRemapRecord.equals("nomap")) {
            marcRemapRecord = null;
        }
        if (marcDeleteSubfields != null) {
            marcDeleteSubfields = marcDeleteSubfields.trim();
        }
        if (reader != null && (marcIncludeIfPresent != null || marcIncludeIfMissing != null || marcDeleteSubfields != null || marcRemapRecord != null)) {
            if (marcRemapRecord != null) {
                String remapFilename = marcRemapRecord.trim();
                String remapURL = PropertyUtils.getPropertyFileAbsoluteURL(searchDirectories, remapFilename, false, null);
                reader = new MarcFilteredReader((MarcReader)reader, marcIncludeIfPresent, marcIncludeIfMissing, marcDeleteSubfields, remapURL);
            } else {
                reader = new MarcFilteredReader((MarcReader)reader, marcIncludeIfPresent, marcIncludeIfMissing, marcDeleteSubfields);
            }
        }
        if (reader != null && this.to_utf_8 && this.unicodeNormalize != null) {
            reader = new MarcTranslatedReader((MarcReader)reader, this.unicodeNormalize);
        }
        return reader;
    }

    private void setMarc4JProperties(Properties configProps) {
        for (String prop : configProps.stringPropertyNames()) {
            if (prop.startsWith("org.marc4j.")) {
                String value = configProps.getProperty(prop);
                System.setProperty(prop, value);
                continue;
            }
            if (PropertyUtils.getProperty(configProps, "marc.override") == null) continue;
            System.setProperty("org.marc4j.marc.MarcFactory", PropertyUtils.getProperty(configProps, "marc.override").trim());
        }
    }

    private String handleUnicodeNormalizeParm(String parm) {
        if (parm == null) {
            return null;
        }
        parm = parm.equalsIgnoreCase("KC") || parm.equalsIgnoreCase("CompatibilityCompose") ? "KC" : (parm.equalsIgnoreCase("C") || parm.equalsIgnoreCase("Compose") || parm.equalsIgnoreCase("true") ? "C" : (parm.equalsIgnoreCase("D") || parm.equalsIgnoreCase("Decompose") ? "D" : (parm.equalsIgnoreCase("KD") || parm.equalsIgnoreCase("CompatibiltyDecompose") ? "KD" : null)));
        return parm;
    }
}

