/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.marc;

import java.text.Normalizer;
import java.util.List;
import org.apache.log4j.Logger;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.solrmarc.marc.MarcFilteredReader;

public class MarcTranslatedReader
implements MarcReader {
    MarcReader reader;
    CharConverter convert;
    private Normalizer.Form unicodeNormalize = null;
    static Logger logger = Logger.getLogger((String)MarcFilteredReader.class.getName());

    public MarcTranslatedReader(MarcReader r, boolean unicodeNormalizeBool) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        if (unicodeNormalizeBool) {
            this.unicodeNormalize = Normalizer.Form.NFC;
        }
    }

    public MarcTranslatedReader(MarcReader r, String unicodeNormalizeStr) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        this.unicodeNormalize = unicodeNormalizeStr.equals("KC") ? Normalizer.Form.NFKC : (unicodeNormalizeStr.equals("KD") ? Normalizer.Form.NFKD : (unicodeNormalizeStr.equals("C") ? Normalizer.Form.NFC : (unicodeNormalizeStr.equals("D") ? Normalizer.Form.NFD : null)));
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public Record next() {
        Record rec = this.reader.next();
        if (this.unicodeNormalize == null) {
            return rec;
        }
        Leader l = rec.getLeader();
        boolean is_utf_8 = false;
        if (l.getCharCodingScheme() == 'a') {
            is_utf_8 = true;
        }
        if (is_utf_8 && this.unicodeNormalize == null) {
            return rec;
        }
        List fields = rec.getVariableFields();
        for (VariableField f : fields) {
            if (!(f instanceof DataField)) continue;
            DataField field = (DataField)f;
            List subfields = field.getSubfields();
            for (Subfield sf : subfields) {
                String oldData;
                String newData = oldData = sf.getData();
                if (!is_utf_8) {
                    newData = this.convert.convert(newData);
                }
                if (this.unicodeNormalize != null) {
                    newData = Normalizer.normalize(newData, this.unicodeNormalize);
                }
                if (oldData.equals(newData)) continue;
                sf.setData(newData);
            }
        }
        l.setCharCodingScheme('a');
        rec.setLeader(l);
        return rec;
    }
}

