/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.marc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.Verifier;
import org.solrmarc.index.SolrIndexer;
import org.solrmarc.tools.PropertyUtils;
import org.solrmarc.tools.Utils;

public class MarcFilteredReader
implements MarcReader {
    String includeRecordIfFieldPresent = null;
    String includeRecordIfFieldContains = null;
    String includeRecordIfFieldMissing = null;
    String includeRecordIfFieldDoesntContain = null;
    String deleteSubfieldsSpec = null;
    Record currentRecord = null;
    MarcReader reader;
    private Properties remapProperties = null;
    static Logger logger = Logger.getLogger((String)MarcFilteredReader.class.getName());
    static Pattern newControlFieldDef = Pattern.compile("=?([0][0][0-9]) [ ]?(.*)");
    static Pattern newDataFieldDef = Pattern.compile("=?([0-9][0-9][0-9]) [ ]?([0-9 \\|])([0-9 \\|])([$].*)");
    static Pattern newSubfieldDef = Pattern.compile("[$]([a-z0-9])(([^$]|\\[$]|[$][{][0-9]*[}])*)(.*)");
    static MarcFactory factory = null;
    static Pattern oneArg = Pattern.compile("[a-z]*[(]\"((\\\"|[^\"])*)\"[ ]*[)]");
    static Pattern twoArgs = Pattern.compile("[a-z]*[(]\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\"[)]");
    static Pattern threeArgs = Pattern.compile("[a-z]*[(][ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\"[)]");
    static Pattern twoConditionals = Pattern.compile("[a-z]*[(]([a-z]*[(].*[)]),[ ]*([a-z]*[(].*[)])[)]");
    static Pattern oneConditional = Pattern.compile("[a-z]*[(]([a-z]*[(].*[)])[)]");

    public MarcFilteredReader(MarcReader r, String ifFieldPresent, String ifFieldMissing, String deleteSubfields) {
        this.deleteSubfieldsSpec = deleteSubfields;
        if (ifFieldPresent != null) {
            String[] present = ifFieldPresent.split("/", 2);
            this.includeRecordIfFieldPresent = present[0];
            if (present.length > 1) {
                this.includeRecordIfFieldContains = present[1];
            }
        }
        if (ifFieldMissing != null) {
            String[] missing = ifFieldMissing.split("/", 2);
            this.includeRecordIfFieldMissing = missing[0];
            if (missing.length > 1) {
                this.includeRecordIfFieldDoesntContain = missing[1];
            }
        }
        this.reader = r;
    }

    public MarcFilteredReader(MarcReader r, String ifFieldPresent, String ifFieldMissing, String deleteSubfields, String remapURL) {
        this(r, ifFieldPresent, ifFieldMissing, deleteSubfields);
        this.remapProperties = PropertyUtils.loadProperties(remapURL);
    }

    public boolean hasNext() {
        if (this.currentRecord == null) {
            this.currentRecord = this.next();
        }
        return this.currentRecord != null;
    }

    public Record next() {
        if (this.currentRecord != null) {
            Record tmp = this.currentRecord;
            this.currentRecord = null;
            return tmp;
        }
        while (this.currentRecord == null) {
            Set<String> fields;
            boolean keepRecord;
            if (!this.reader.hasNext()) {
                return null;
            }
            Record rec = null;
            try {
                rec = this.reader.next();
            }
            catch (MarcException me) {
                logger.error((Object)"Error reading Marc Record.");
                logger.error((Object)me.getMessage());
                throw me;
            }
            if (this.deleteSubfieldsSpec != null) {
                this.deleteSubfields(rec);
            }
            if (this.remapProperties != null && !(keepRecord = this.remapRecord(rec))) {
                logger.info((Object)("Remap Rules say record " + rec.getControlNumber() + " should be skipped"));
                continue;
            }
            if (rec != null && this.includeRecordIfFieldPresent != null && (fields = SolrIndexer.instance().getFieldList(rec, this.includeRecordIfFieldPresent)).size() != 0 && (this.includeRecordIfFieldContains == null || Utils.setItemContains(fields, this.includeRecordIfFieldContains))) {
                this.currentRecord = rec;
            }
            if (rec != null && this.includeRecordIfFieldMissing != null) {
                fields = SolrIndexer.instance().getFieldList(rec, this.includeRecordIfFieldMissing);
                if (this.includeRecordIfFieldDoesntContain == null && fields.size() == 0 || this.includeRecordIfFieldDoesntContain != null && !Utils.setItemContains(fields, this.includeRecordIfFieldDoesntContain)) {
                    this.currentRecord = rec;
                }
            }
            if (rec == null || this.includeRecordIfFieldPresent != null || this.includeRecordIfFieldMissing != null) continue;
            this.currentRecord = rec;
        }
        return this.currentRecord;
    }

    void deleteSubfields(Record rec) {
        String[] fieldSpecs;
        for (String fieldSpec : fieldSpecs = this.deleteSubfieldsSpec.split(":")) {
            String tag = fieldSpec.substring(0, 3);
            String subfield = null;
            if (fieldSpec.length() > 3) {
                subfield = fieldSpec.substring(3);
            }
            List list = rec.getVariableFields(tag);
            for (VariableField field : list) {
                if (!(field instanceof DataField)) continue;
                DataField df = (DataField)field;
                if (subfield != null) {
                    List sfs = df.getSubfields(subfield.charAt(0));
                    if (sfs == null || sfs.size() == 0) continue;
                    rec.removeVariableField((VariableField)df);
                    for (Subfield sf : sfs) {
                        df.removeSubfield(sf);
                    }
                    rec.addVariableField((VariableField)df);
                    continue;
                }
                rec.removeVariableField((VariableField)df);
            }
        }
    }

    private boolean remapRecord(Record rec) {
        List fields = rec.getVariableFields();
        ArrayList<VariableField> fToDelete = new ArrayList<VariableField>();
        ArrayList<VariableField> fToInsert = new ArrayList<VariableField>();
        boolean keepRecord = true;
        for (VariableField field : fields) {
            String tag = field.getTag();
            if (this.remapProperties.containsKey(tag)) {
                if (Verifier.isControlNumberField((String)tag)) {
                    int i = 0;
                    while (this.remapProperties.containsKey(tag + "_" + i)) {
                        String remapString = this.remapProperties.getProperty(tag + "_" + i);
                        String[] mapParts = remapString.split("=>");
                        if (this.eval(mapParts[0], (VariableField)((ControlField)field), rec)) {
                            keepRecord &= this.process(mapParts[1], field, null, fToDelete, fToInsert, rec);
                        }
                        ++i;
                    }
                } else {
                    ArrayList<Subfield> sfToDelete = new ArrayList<Subfield>();
                    int i = 0;
                    while (this.remapProperties.containsKey(tag + "_" + i)) {
                        String remapString = this.remapProperties.getProperty(tag + "_" + i);
                        String[] mapParts = remapString.split("=>");
                        if (this.eval(mapParts[0], (VariableField)((DataField)field), rec)) {
                            keepRecord &= this.process(mapParts[1], field, sfToDelete, fToDelete, fToInsert, rec);
                        }
                        ++i;
                    }
                    if (sfToDelete.size() != 0) {
                        for (Subfield sf : sfToDelete) {
                            ((DataField)field).removeSubfield(sf);
                        }
                    }
                }
            }
            if (keepRecord) continue;
            break;
        }
        if (keepRecord && this.remapProperties.containsKey("once")) {
            int i = 0;
            while (this.remapProperties.containsKey("once_" + i)) {
                String remapString = this.remapProperties.getProperty("once_" + i);
                String[] mapParts = remapString.split("=>");
                if (this.eval(mapParts[0], null, rec)) {
                    keepRecord &= this.process(mapParts[1], null, null, fToDelete, fToInsert, rec);
                }
                ++i;
            }
        }
        if (keepRecord && fToDelete.size() != 0) {
            for (VariableField field : fToDelete) {
                rec.removeVariableField(field);
            }
        }
        if (keepRecord && fToInsert.size() != 0) {
            for (VariableField field : fToInsert) {
                ControlField df;
                if (field instanceof DataField) {
                    DataField df2;
                    int index = 0;
                    Iterator iterator = rec.getDataFields().iterator();
                    while (iterator.hasNext() && (df2 = (DataField)iterator.next()).getTag().compareTo(field.getTag()) < 0) {
                        ++index;
                    }
                    rec.getDataFields().add(index, (DataField)field);
                    continue;
                }
                if (field.getTag().equals("001")) {
                    rec.addVariableField(field);
                    continue;
                }
                if (!(field instanceof ControlField)) continue;
                int index = 0;
                Iterator iterator = rec.getControlFields().iterator();
                while (iterator.hasNext() && (df = (ControlField)iterator.next()).getTag().compareTo(field.getTag()) < 0) {
                    ++index;
                }
                rec.getControlFields().add(index, (ControlField)field);
            }
        }
        return keepRecord;
    }

    private boolean eval(String conditional, VariableField field, Record record) {
        if (conditional.startsWith("true()")) {
            return true;
        }
        if (conditional.startsWith("not(")) {
            String arg = this.getOneConditional(conditional);
            if (arg != null) {
                return !this.eval(arg, field, record);
            }
        } else if (conditional.startsWith("indicatormatches(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1 && args[1].length() == 1) {
                char indicator1 = ((DataField)field).getIndicator1();
                char indicator2 = ((DataField)field).getIndicator2();
                return !(args[0].charAt(0) != '*' && args[0].charAt(0) != indicator1 || args[1].charAt(0) != '*' && args[1].charAt(0) != indicator2);
            }
        } else if (conditional.startsWith("subfieldmatches(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    if (!sf.getData().matches(args[1])) continue;
                    return true;
                }
            } else if (field != null && field instanceof ControlField && args.length == 2 && ((ControlField)field).getData().matches(args[1])) {
                return true;
            }
        } else if (conditional.startsWith("subfieldcontains(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    if (!sf.getData().contains(args[1])) continue;
                    return true;
                }
            } else if (field != null && field instanceof ControlField && args.length == 2 && ((ControlField)field).getData().contains(args[1])) {
                return true;
            }
        } else if (conditional.startsWith("subfieldexists(")) {
            List subfields;
            String arg = this.getOneArg(conditional);
            if (field != null && field instanceof DataField && arg.length() == 1 ? (subfields = ((DataField)field).getSubfields(arg.charAt(0))).size() > 0 : field != null && field instanceof ControlField) {
                return true;
            }
        } else if (conditional.startsWith("and(")) {
            String[] args = this.getTwoConditionals(conditional);
            if (args.length == 2) {
                return this.eval(args[0], field, record) && this.eval(args[1], field, record);
            }
        } else if (conditional.startsWith("or(")) {
            String[] args = this.getTwoConditionals(conditional);
            if (args.length == 2) {
                return this.eval(args[0], field, record) || this.eval(args[1], field, record);
            }
        } else if (conditional.startsWith("fieldexists(")) {
            String[] args = this.getThreeArgs(conditional);
            if (args.length == 3 && args[0].matches("[0-9][0-9][0-9]") && args[1].length() == 1) {
                for (VariableField vf : record.getVariableFields(args[0])) {
                    if (!(vf instanceof DataField)) continue;
                    for (Subfield sf : ((DataField)vf).getSubfields(args[1].charAt(0))) {
                        if (!sf.getData().equals(args[2]) && !sf.getData().matches(args[2])) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    private boolean process(String command, VariableField field, List<Subfield> sfToDelete, List<VariableField> fToDelete, List<VariableField> fToInsert, Record record) {
        if (command.startsWith("replace(")) {
            String newData;
            String[] args = this.getThreeArgs(command);
            if (field != null && field instanceof DataField && args.length == 3 && args[0].length() == 1) {
                List subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData2 = sf.getData().replaceAll(args[1], args[2]);
                    if (newData2.equals(sf.getData())) continue;
                    sf.setData(newData2);
                }
            } else if (field != null && field instanceof ControlField && args.length == 3 && !(newData = ((ControlField)field).getData().replaceAll(args[1], args[2])).equals(((ControlField)field).getData())) {
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("append(")) {
            String[] args = this.getTwoArgs(command);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData = sf.getData() + args[1];
                    if (newData.equals(sf.getData())) continue;
                    sf.setData(newData);
                }
            } else if (field != null && field instanceof ControlField && args.length == 2) {
                String newData = ((ControlField)field).getData() + args[1];
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("prepend(")) {
            String[] args = this.getTwoArgs(command);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData = args[1] + sf.getData();
                    if (newData.equals(sf.getData())) continue;
                    sf.setData(newData);
                }
            } else if (field != null && field instanceof ControlField && args.length == 2) {
                String newData = args[1] + ((ControlField)field).getData();
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("deletesubfield(")) {
            String arg = this.getOneArg(command);
            if (field != null && field instanceof DataField && arg.length() == 1) {
                List subfields = ((DataField)field).getSubfields(arg.charAt(0));
                for (Subfield sf : subfields) {
                    sfToDelete.add(sf);
                }
            } else if (field != null && field instanceof ControlField) {
                fToDelete.add(field);
            }
        } else if (command.startsWith("both(")) {
            String[] args = this.getTwoConditionals(command);
            boolean returncode = true;
            if (args.length == 2) {
                returncode = this.process(args[0], field, sfToDelete, fToDelete, fToInsert, record);
                returncode &= this.process(args[1], field, sfToDelete, fToDelete, fToInsert, record);
            }
        } else if (command.startsWith("deletefield(")) {
            fToDelete.add(field);
        } else if (command.startsWith("deleteotherfield(")) {
            String[] args = this.getThreeArgs(command);
            if (args.length == 3 && args[0].matches("[0-9][0-9][0-9]") && args[1].length() == 1) {
                for (VariableField vf : record.getVariableFields(args[0])) {
                    List subfields = ((DataField)vf).getSubfields(args[1].charAt(0));
                    for (Subfield sf : subfields) {
                        if (!sf.getData().equals(args[2]) && !sf.getData().matches(args[2])) continue;
                        fToDelete.add(vf);
                    }
                }
            }
        } else if (command.startsWith("insertfield(")) {
            String arg = this.getOneArg(command);
            VariableField vf = this.createFieldFromString(arg, null);
            if (vf != null) {
                fToInsert.add(vf);
            }
        } else if (command.startsWith("insertparameterizedfield(")) {
            String[] args = this.getThreeArgs(command);
            Pattern p = Pattern.compile(args[2]);
            Matcher m = field != null && field instanceof DataField ? p.matcher(((DataField)field).getSubfield(args[1].charAt(0)).getData()) : p.matcher(((ControlField)field).getData());
            VariableField vf = m.matches() ? this.createFieldFromString(args[0], this.stringsFromMatcher(m)) : this.createFieldFromString(args[0], null);
            if (vf != null) {
                fToInsert.add(vf);
            }
        } else if (command.startsWith("reject()")) {
            return false;
        }
        return true;
    }

    private String[] stringsFromMatcher(Matcher m) {
        String[] result = new String[m.groupCount() + 1];
        result[0] = m.group(0);
        for (int i = 0; i < m.groupCount(); ++i) {
            result[i + 1] = m.group(i + 1);
        }
        return result;
    }

    private VariableField createFieldFromString(String arg, String[] argmatches) {
        Matcher mdf = newDataFieldDef.matcher(arg);
        Matcher cdf = newControlFieldDef.matcher(arg);
        if (factory == null) {
            factory = MarcFactory.newInstance();
        }
        if (cdf.matches()) {
            ControlField cf = factory.newControlField(mdf.group(1));
            String data = cdf.group(2);
            if (argmatches != null) {
                data = this.fillParameters(data, argmatches);
            }
            cf.setData(data);
            return cf;
        }
        if (mdf.matches()) {
            char ind2;
            char ind1 = mdf.group(2).charAt(0);
            if (ind1 < '0' || ind1 > '9') {
                ind1 = ' ';
            }
            if ((ind2 = mdf.group(3).charAt(0)) < '0' || ind2 > '9') {
                ind2 = ' ';
            }
            DataField df = factory.newDataField(mdf.group(1), ind1, ind2);
            String sfData = mdf.group(4);
            while (!sfData.isEmpty()) {
                Matcher sm = newSubfieldDef.matcher(sfData);
                if (!sm.matches()) continue;
                char code = sm.group(1).charAt(0);
                String data = sm.group(2);
                if (argmatches != null) {
                    data = this.fillParameters(data, argmatches);
                }
                sfData = sm.group(4);
                Subfield sf = factory.newSubfield(code, data);
                df.addSubfield(sf);
            }
            return df;
        }
        return null;
    }

    private String fillParameters(String data, String[] argmatches) {
        for (int i = 0; i < argmatches.length; ++i) {
            if (!data.contains("${" + (i + 1) + "}")) continue;
            data = data.replaceAll("[$][{]" + (i + 1) + "[}]", argmatches[i + 1]);
        }
        return data;
    }

    private String getOneArg(String conditional) {
        Matcher m = oneArg.matcher(conditional.trim());
        if (m.matches()) {
            return m.group(1).replaceAll("\\\"", "\"");
        }
        return null;
    }

    private String[] getTwoArgs(String conditional) {
        Matcher m = twoArgs.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1).replaceAll("\\\"", "\""), m.group(3).replaceAll("\\\"", "\"")};
            return result;
        }
        return null;
    }

    private String[] getThreeArgs(String conditional) {
        Matcher m = threeArgs.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1).replaceAll("\\\"", "\""), m.group(3).replaceAll("\\\"", "\""), m.group(5).replaceAll("\\\"", "\"")};
            return result;
        }
        return null;
    }

    private String[] getTwoConditionals(String conditional) {
        Matcher m = twoConditionals.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1), m.group(2)};
            return result;
        }
        return null;
    }

    private String getOneConditional(String conditional) {
        Matcher m = oneConditional.matcher(conditional.trim());
        if (m.matches()) {
            String result = m.group(1);
            return result;
        }
        return null;
    }
}

