/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.utils;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.solrmarc.driver.Boot;
import org.solrmarc.driver.BootableMain;
import org.solrmarc.driver.LoggerDelegator;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.impl.custom.Mixin;
import org.solrmarc.index.mapping.AbstractValueMappingFactory;
import org.solrmarc.index.utils.ClasspathUtils;

public class ClassGraphUtils
extends ClasspathUtils {
    public static final LoggerDelegator logger = new LoggerDelegator(ClassGraphUtils.class);

    private void getMatchingClasses() {
        this.extractors = new LinkedHashSet();
        this.mappers = new LinkedHashSet();
        this.mixins = new LinkedHashSet();
        try {
            Boot.classForName("bsh.Interpreter");
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find BeanShell Interpreter class:  any index specification that uses BeanShell scripts will cause an error:" + e.getMessage());
        }
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().scan();){
            ClassInfoList extractorClassInfo = scanResult.getSubclasses("org.solrmarc.index.extractor.AbstractValueExtractorFactory");
            for (Object classInfo : extractorClassInfo) {
                Class<?> clazz = Boot.classForName(classInfo.getName());
                this.extractors.add(clazz);
            }
            ClassInfoList mapperClassInfo = scanResult.getSubclasses("org.solrmarc.index.mapping.AbstractValueMappingFactory");
            for (ClassInfo classInfo : mapperClassInfo) {
                Class<?> clazz = Boot.classForName(classInfo.getName());
                this.mappers.add(clazz);
            }
            ClassInfoList mixinClassInfo = scanResult.getClassesImplementing("org.solrmarc.index.extractor.impl.custom.Mixin");
            for (ClassInfo classInfo : mixinClassInfo) {
                Class<?> clazz = Boot.classForName(classInfo.getName());
                this.mixins.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<Class<? extends AbstractValueExtractorFactory>> getExtractorFactoryClasses() {
        if (this.extractors == null) {
            this.getMatchingClasses();
        }
        if (this.extractors.size() == 0) {
            logger.warn("Classpath scanning failed, using default extractors only");
            this.extractors = super.getExtractorFactoryClasses();
        }
        return this.extractors;
    }

    @Override
    public Set<Class<? extends AbstractValueMappingFactory>> getMappingFactoryClasses() {
        if (this.mappers == null) {
            this.getMatchingClasses();
        }
        if (this.mappers.size() == 0) {
            logger.warn("Classpath scanning failed, using default mapping classes only");
            this.mappers = super.getMappingFactoryClasses();
        }
        return this.mappers;
    }

    @Override
    public Set<Class<? extends Mixin>> getMixinClasses() {
        if (this.mixins == null) {
            this.getMatchingClasses();
        }
        if (this.mixins.size() == 0) {
            logger.warn("Classpath scanning failed, using default mixin classes only");
            super.getMixinClasses();
        }
        return this.mixins;
    }

    private void getMatchingBootableClasses() {
        this.bootables = new LinkedHashSet();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().scan();){
            ClassInfoList bootableClassInfo = scanResult.getSubclasses("org.solrmarc.driver.BootableMain");
            for (ClassInfo classInfo : bootableClassInfo) {
                Class<?> clazz = Boot.classForName(classInfo.getName());
                this.bootables.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<Class<? extends BootableMain>> getBootableMainClasses() {
        if (this.bootables == null) {
            this.getMatchingBootableClasses();
        }
        if (this.bootables.size() == 0) {
            logger.warn("Classpath scanning failed, using default bootable classes only");
            super.getBootableMainClasses();
        }
        return this.bootables;
    }

    private void getClassPathForCompiling() {
        this.classpathForCompiling = new ArrayList();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().scan();){
            List classpathURLForCompiling = scanResult.getClasspathURLs();
            for (URL url : classpathURLForCompiling) {
                this.classpathForCompiling.add(new File(url.getFile()));
            }
        }
    }

    @Override
    public List<File> getClassPath() {
        if (this.classpathForCompiling == null || this.classpathForCompiling.size() == 0) {
            this.getClassPathForCompiling();
        }
        return this.classpathForCompiling;
    }
}

