/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification.conditional;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.indexer.FullConditionalParser;
import org.solrmarc.index.specification.conditional.Condition;

public class ConditionSubfield
extends Condition {
    char sfCode;
    final String value;
    final Pattern valuePattern;
    int op;

    public ConditionSubfield(String offsetStr, String value, int op) {
        this(null, offsetStr, value, op);
    }

    public ConditionSubfield(String fieldTag, String offsetStr, String value, int op) {
        super(fieldTag);
        this.sfCode = offsetStr.charAt(0);
        this.value = value;
        this.op = op;
        if (op == 26) {
            Pattern tmp;
            try {
                tmp = Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                tmp = Pattern.compile("");
                FullConditionalParser.addError("Invalid Regular Expression in Condition: " + value);
                FullConditionalParser.addError(pse.getMessage());
            }
            this.valuePattern = tmp;
        } else {
            this.valuePattern = null;
        }
    }

    @Override
    public boolean matches(VariableField f) {
        if (f instanceof ControlField) {
            return false;
        }
        List sfl = ((DataField)f).getSubfields(this.sfCode);
        for (Subfield sf : sfl) {
            String sfVal = sf == null ? null : sf.getData();
            switch (this.op) {
                case 22: {
                    if (!sfVal.equals(this.value)) break;
                    return true;
                }
                case 27: {
                    if (!sfVal.contains(this.value)) break;
                    return true;
                }
                case 25: {
                    if (!sfVal.startsWith(this.value)) break;
                    return true;
                }
                case 24: {
                    if (!sfVal.endsWith(this.value)) break;
                    return true;
                }
                case 23: {
                    if (!sfVal.equals(this.value)) break;
                    return false;
                }
                case 26: {
                    if (this.valuePattern == null || !this.valuePattern.matcher(sfVal).matches()) break;
                    return true;
                }
            }
        }
        return this.op == 23;
    }
}

