/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification.conditional;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.indexer.FullConditionalParser;
import org.solrmarc.index.specification.conditional.Condition;

public class ConditionPosition
extends Condition {
    int offset;
    int endOffset;
    final String value;
    final Pattern valuePattern;
    int op;

    public ConditionPosition(String offsetStr, String value, int op) {
        this(null, offsetStr, value, op);
    }

    public ConditionPosition(String fieldTag, String offsetStr, String value, int op) {
        super(fieldTag);
        this.endOffset = this.offset = Integer.parseInt(offsetStr.replaceAll("\\[([0-9]+)(-[0-9]+)?\\]", "$1"));
        String endOffsetStr = offsetStr.replaceAll("\\[([0-9]+)(-)?([0-9]+)?\\]", "$3");
        if (endOffsetStr != null && endOffsetStr.length() > 0) {
            this.endOffset = Integer.parseInt(endOffsetStr);
        }
        this.op = op;
        this.value = value;
        if (op == 26) {
            Pattern tmp;
            try {
                tmp = Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                tmp = Pattern.compile("");
                FullConditionalParser.addError("Invalid Regular Expression in Condition: " + value);
                FullConditionalParser.addError(pse.getMessage());
            }
            this.valuePattern = tmp;
        } else {
            this.valuePattern = null;
        }
    }

    @Override
    public boolean matches(VariableField f) {
        if (!(f instanceof ControlField)) {
            return false;
        }
        String data = ((ControlField)f).getData();
        if (data.length() < this.offset) {
            return false;
        }
        String posVal = data.substring(this.offset, this.endOffset + 1);
        switch (this.op) {
            case 22: {
                return posVal.equals(this.value);
            }
            case 27: {
                return posVal.contains(this.value);
            }
            case 25: {
                return posVal.startsWith(this.value);
            }
            case 24: {
                return posVal.endsWith(this.value);
            }
            case 23: {
                return !posVal.equals(this.value);
            }
            case 26: {
                return this.valuePattern.matcher(posVal).matches();
            }
        }
        return false;
    }
}

