/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification.conditional;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.indexer.FullConditionalParser;
import org.solrmarc.index.specification.conditional.Condition;

public class ConditionIndicator
extends Condition {
    int indicatorNum;
    final String value;
    final Pattern valuePattern;
    int op;

    public ConditionIndicator(String indicatorStr, String value, int op) {
        this(null, indicatorStr, value, op);
    }

    public ConditionIndicator(String fieldTag, String indicatorStr, String value, int op) {
        super(fieldTag);
        this.indicatorNum = indicatorStr.equals("1") ? 1 : 2;
        this.value = value;
        this.op = op;
        if (op == 26) {
            Pattern tmp;
            try {
                tmp = Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                tmp = Pattern.compile("");
                FullConditionalParser.addError("Invalid Regular Expression in Condition: " + value);
                FullConditionalParser.addError(pse.getMessage());
            }
            this.valuePattern = tmp;
        } else {
            this.valuePattern = null;
        }
    }

    @Override
    public boolean matches(VariableField f) {
        if (f instanceof ControlField) {
            return false;
        }
        char indVal = this.indicatorNum == 1 ? ((DataField)f).getIndicator1() : ((DataField)f).getIndicator2();
        switch (this.op) {
            case 22: {
                return indVal == this.value.charAt(0);
            }
            case 25: {
                return indVal < this.value.charAt(0);
            }
            case 24: {
                return indVal > this.value.charAt(0);
            }
            case 23: {
                return indVal != this.value.charAt(0);
            }
            case 26: {
                return this.valuePattern.matcher("" + indVal).matches();
            }
        }
        return false;
    }
}

