/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.impl.direct.FieldMatch;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.conditional.Condition;

public abstract class Specification
implements ExternalMethod {
    String specLabel;
    public static final Pattern dotPattern = Pattern.compile(".");

    public abstract void addConditional(Condition var1);

    public abstract boolean conditionalMatches(Record var1, VariableField var2);

    public abstract String[] getTags();

    public List<FieldMatch> getFieldMatches(Record record) {
        String[] tags = this.getTags();
        List fields = record.getVariableFields(tags);
        ArrayList<FieldMatch> result = new ArrayList<FieldMatch>(fields.size());
        for (VariableField vf : fields) {
            Specification specUsed = this.getMatchingSpec(vf.getTag(), vf);
            if (specUsed == null || !specUsed.conditionalMatches(record, vf)) continue;
            result.add(new FieldMatch(vf, specUsed));
        }
        return result;
    }

    public boolean hasDuplicateTags() {
        return false;
    }

    protected abstract Specification getMatchingSpec(String var1, VariableField var2);

    public abstract void addFieldValues(Collection<String> var1, VariableField var2) throws Exception;

    public String getSpecLabel() {
        return this.specLabel;
    }

    public void setSpecLabel(String specLabel) {
        this.specLabel = specLabel;
    }

    public abstract void setFormatter(FieldFormatter var1);

    public abstract void addCleanVal(FieldFormatter.eCleanVal var1);

    public abstract void setCleanVal(EnumSet<FieldFormatter.eCleanVal> var1);

    public abstract void setJoinVal(FieldFormatter.eJoinVal var1);

    public abstract void setSubstring(int var1, int var2);

    public abstract void setSeparator(String var1);

    public abstract void setFormatPatterns(String[] var1);

    public abstract void addMap(AbstractMultiValueMapping var1);
}

