/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import java.util.Collection;
import java.util.EnumSet;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.formatter.FieldFormatterBase;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.Specification;
import org.solrmarc.index.specification.conditional.Condition;

public abstract class SingleSpecification
extends Specification {
    protected String tag;
    Condition cond = null;
    protected FieldFormatter fmt;
    String[] tags;

    public SingleSpecification(String tag, Condition cond) {
        this.tag = tag;
        this.cond = cond;
        this.tags = new String[1];
        this.tags[0] = tag;
        this.fmt = new FieldFormatterBase(false);
    }

    protected SingleSpecification(SingleSpecification toClone) {
        this.tag = toClone.tag;
        this.cond = toClone.cond;
        this.tags = new String[1];
        this.tags[0] = toClone.tag;
        this.fmt = toClone.fmt.isThreadSafe() ? toClone.fmt : (FieldFormatter)toClone.fmt.makeThreadSafeCopy();
    }

    @Override
    public void addConditional(Condition cond) {
        if (this.cond == null) {
            this.cond = cond;
        }
    }

    @Override
    public boolean conditionalMatches(Record record, VariableField vf) {
        return this.cond == null || this.cond.matches(record, vf);
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    @Override
    protected SingleSpecification getMatchingSpec(String tag, VariableField f) {
        if (this.specMatches(tag, f)) {
            return this;
        }
        return null;
    }

    protected boolean specMatches(String tag, VariableField f) {
        String stag = this.tag;
        return tag.equals(stag);
    }

    @Override
    public abstract void addFieldValues(Collection<String> var1, VariableField var2) throws Exception;

    @Override
    public void addMap(AbstractMultiValueMapping valueMapping) {
        if (this.fmt != null) {
            this.fmt.addMap(valueMapping);
        }
    }

    @Override
    public void setFormatter(FieldFormatter fmt) {
        this.fmt = fmt;
    }

    @Override
    public void addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        this.fmt.addCleanVal(cleanVal);
    }

    @Override
    public void setCleanVal(EnumSet<FieldFormatter.eCleanVal> of) {
        this.fmt.setCleanVal(of);
    }

    @Override
    public void setJoinVal(FieldFormatter.eJoinVal joinVal) {
        this.fmt.setJoinVal(joinVal);
    }

    @Override
    public void setSubstring(int offset, int endOffset) {
        this.fmt.setSubstring(offset, endOffset);
    }

    @Override
    public void setSeparator(String separator) {
        this.fmt.setSeparator(separator);
    }

    @Override
    public void setFormatPatterns(String[] mapParts) {
        this.fmt.setSfCodeFmt(mapParts);
    }

    @Override
    public boolean isThreadSafe() {
        return this.fmt.isThreadSafe();
    }
}

