/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import java.util.Collection;
import java.util.regex.Pattern;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.formatter.FieldFormatterBase;
import org.solrmarc.index.specification.SingleSpecification;
import org.solrmarc.index.specification.conditional.Condition;

public class SingleDataFieldSpecification
extends SingleSpecification {
    String subfields;
    Pattern subfieldPattern;

    public SingleDataFieldSpecification(String tag, String subfields, Condition cond, FieldFormatter fmt) {
        super(tag, cond);
        this.subfields = subfields;
        this.subfieldPattern = SingleDataFieldSpecification.makePattern(subfields);
        this.fmt = fmt;
    }

    public SingleDataFieldSpecification(String tag, String subfields, Condition cond) {
        super(tag, cond);
        this.subfields = subfields;
        this.subfieldPattern = SingleDataFieldSpecification.makePattern(subfields);
        this.fmt = subfields != null && subfields.length() == 1 ? new FieldFormatterBase(false).setJoinVal(FieldFormatter.eJoinVal.SEPARATE) : new FieldFormatterBase(false).setJoinVal(FieldFormatter.eJoinVal.JOIN).setSeparator(" ");
    }

    public SingleDataFieldSpecification(String tag, String subfields) {
        this(tag, subfields, null);
    }

    protected SingleDataFieldSpecification(SingleDataFieldSpecification toClone) {
        super(toClone.tag, toClone.cond);
        this.subfields = toClone.subfields;
        this.subfieldPattern = toClone.subfieldPattern;
        this.fmt = (FieldFormatter)(toClone.fmt.isThreadSafe() ? toClone.fmt : toClone.fmt.makeThreadSafeCopy());
    }

    private static final Pattern makePattern(String subfields) {
        if (subfields == null || subfields.length() == 0) {
            return dotPattern;
        }
        if (subfields.startsWith("[") && subfields.endsWith("]")) {
            return Pattern.compile(subfields);
        }
        return Pattern.compile("[" + subfields + "]");
    }

    @Override
    public void setFormatter(FieldFormatter fmt) {
        this.fmt = fmt;
    }

    @Override
    public void addFieldValues(Collection<String> result, VariableField vf) throws Exception {
        SingleDataFieldSpecification.addDataFieldValues(result, vf, this.fmt, this.subfieldPattern);
    }

    public static void addDataFieldValues(Collection<String> result, VariableField vf, FieldFormatter fmt, Pattern subfieldPattern) throws Exception {
        DataField df = (DataField)vf;
        StringBuilder sb = fmt.start();
        if (fmt.hasFieldFormat()) {
            sb.append(fmt.getFieldFormat());
        }
        fmt.addTag(sb, (VariableField)df);
        fmt.addIndicators(sb, (VariableField)df);
        int cnt = 0;
        for (Subfield subfield : df.getSubfields()) {
            String codeStr = "" + subfield.getCode();
            if (!subfieldPattern.equals(dotPattern) && !subfieldPattern.matcher(codeStr).matches()) continue;
            fmt.addSeparator(sb, cnt);
            Collection<String> prepped = fmt.prepData(vf, subfield.getCode() == 'a', subfield.getData());
            for (String val : prepped) {
                val = fmt.handleSubFieldFormat(codeStr, vf, val);
                fmt.addVal(sb, codeStr, val);
                fmt.addAfterSubfield(sb, result);
            }
            ++cnt;
        }
        fmt.addAfterField(sb, result);
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new SingleDataFieldSpecification(this);
    }
}

