/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.RecordImpl;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.formatter.FieldFormatterBase;
import org.solrmarc.index.extractor.impl.direct.FieldMatch;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.SingleControlFieldSpecification;
import org.solrmarc.index.specification.SingleDataFieldSpecification;
import org.solrmarc.index.specification.Specification;
import org.solrmarc.index.specification.conditional.Condition;

public class RegexSpecification
extends Specification {
    Pattern regex = null;
    Condition cond = null;
    boolean duplicateTags = false;
    protected FieldFormatter fmt;
    private static final String[] defaultSubFieldCodeFmt = new String[]{"*=> $%sf %d", " => %d"};

    public RegexSpecification(String regexStr) {
        this.regex = Pattern.compile(regexStr);
        this.cond = null;
        this.fmt = this.makeRawFieldFormattter();
    }

    public RegexSpecification(String regexStr, Condition cond) {
        this.regex = Pattern.compile(regexStr);
        this.cond = cond;
        this.fmt = this.makeRawFieldFormattter();
    }

    private FieldFormatter makeRawFieldFormattter() {
        FieldFormatterBase f = new FieldFormatterBase(false);
        f.setIndicatorFmt("%1%2");
        f.setFieldTagFmt("%tag ");
        f.setSfCodeFmt(defaultSubFieldCodeFmt);
        f.setJoinVal(FieldFormatter.eJoinVal.JOIN);
        return f;
    }

    private RegexSpecification(RegexSpecification toClone) {
        this.regex = toClone.regex;
        this.cond = toClone.cond;
        this.duplicateTags = toClone.duplicateTags;
        this.fmt = toClone.fmt.isThreadSafe() ? toClone.fmt : (FieldFormatter)toClone.fmt.makeThreadSafeCopy();
    }

    @Override
    public boolean hasDuplicateTags() {
        return this.duplicateTags;
    }

    @Override
    public List<FieldMatch> getFieldMatches(Record record) {
        ArrayList<FieldMatch> result = null;
        result = new ArrayList<FieldMatch>();
        List fields = ((RecordImpl)record).getVariableFieldsWithLeader();
        for (VariableField vf : fields) {
            if (!this.regex.matcher(vf.getTag()).matches() || this.cond != null && !this.cond.matches(record, vf)) continue;
            result.add(new FieldMatch(vf, this));
        }
        return result;
    }

    @Override
    public void addFieldValues(Collection<String> result, VariableField vf) throws Exception {
        if (vf instanceof ControlField) {
            SingleControlFieldSpecification.addControlFieldValues(result, vf, this.fmt);
        } else {
            SingleDataFieldSpecification.addDataFieldValues(result, vf, this.fmt, dotPattern);
        }
    }

    @Override
    protected Specification getMatchingSpec(String tag, VariableField f) {
        return this;
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new RegexSpecification(this);
    }

    @Override
    public void addMap(AbstractMultiValueMapping valueMapping) {
        if (this.fmt != null) {
            this.fmt.addMap(valueMapping);
        }
    }

    @Override
    public void setFormatter(FieldFormatter fmt) {
        this.fmt = fmt;
    }

    @Override
    public void addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        this.fmt.addCleanVal(cleanVal);
    }

    @Override
    public void setCleanVal(EnumSet<FieldFormatter.eCleanVal> of) {
        this.fmt.setCleanVal(of);
    }

    @Override
    public void setJoinVal(FieldFormatter.eJoinVal joinVal) {
        this.fmt.setJoinVal(joinVal);
    }

    @Override
    public void setSubstring(int offset, int endOffset) {
        this.fmt.setSubstring(offset, endOffset);
    }

    @Override
    public void setSeparator(String separator) {
        this.fmt.setSeparator(separator);
    }

    @Override
    public void setFormatPatterns(String[] mapParts) {
        this.fmt.setSfCodeFmt(mapParts);
    }

    @Override
    public boolean conditionalMatches(Record record, VariableField vf) {
        return this.cond == null || this.cond.matches(record, vf);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void addConditional(Condition cond) {
        if (this.cond == null) {
            this.cond = cond;
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }
}

