/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.impl.direct.FieldMatch;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.specification.SingleSpecification;
import org.solrmarc.index.specification.Specification;
import org.solrmarc.index.specification.conditional.Condition;

public class CompositeSpecification
extends Specification {
    List<SingleSpecification> pieces = null;
    List<String> tagsUsed = null;
    String[] tags = null;
    boolean duplicateTags = false;

    public CompositeSpecification() {
    }

    public CompositeSpecification(Specification spec) {
        this.addSpec(spec);
    }

    private CompositeSpecification(CompositeSpecification toClone) {
        this.pieces = new ArrayList<SingleSpecification>(toClone.pieces.size());
        for (SingleSpecification spec : toClone.pieces) {
            this.pieces.add((SingleSpecification)(spec.isThreadSafe() ? spec : spec.makeThreadSafeCopy()));
        }
        this.tagsUsed = toClone.tagsUsed;
        this.tags = toClone.tags;
        this.duplicateTags = toClone.duplicateTags;
    }

    @Override
    public boolean hasDuplicateTags() {
        return this.duplicateTags;
    }

    public void addSpec(Specification spec) {
        if (this.pieces == null) {
            this.pieces = new ArrayList<SingleSpecification>();
        }
        if (this.tagsUsed == null) {
            this.tagsUsed = new ArrayList<String>();
        }
        if (spec instanceof SingleSpecification) {
            if (this.tagsUsed.contains(((SingleSpecification)spec).tags[0])) {
                this.duplicateTags = true;
            } else {
                this.tagsUsed.add(((SingleSpecification)spec).tags[0]);
            }
            this.pieces.add((SingleSpecification)spec);
        } else {
            if (spec.hasDuplicateTags()) {
                this.duplicateTags = true;
            }
            for (String t : ((CompositeSpecification)spec).tagsUsed) {
                if (this.tagsUsed.contains(t)) {
                    this.duplicateTags = true;
                    continue;
                }
                this.tagsUsed.add(t);
            }
            this.pieces.addAll(((CompositeSpecification)spec).pieces);
        }
    }

    @Override
    public void addConditional(Condition cond) {
        for (Specification specification : this.pieces) {
            specification.addConditional(cond);
        }
    }

    @Override
    public List<FieldMatch> getFieldMatches(Record record) {
        ArrayList<FieldMatch> result = null;
        if (!this.hasDuplicateTags()) {
            return super.getFieldMatches(record);
        }
        result = new ArrayList<FieldMatch>();
        List fields = record.getVariableFields(this.getTags());
        for (SingleSpecification spec : this.pieces) {
            for (VariableField vf : fields) {
                if (!spec.specMatches(vf.getTag(), vf) || spec.cond != null && !spec.cond.matches(record, vf)) continue;
                result.add(new FieldMatch(vf, spec));
            }
        }
        return result;
    }

    @Override
    public String[] getTags() {
        if (this.tags == null) {
            this.tags = this.tagsUsed.toArray(new String[this.tagsUsed.size()]);
        }
        return this.tags;
    }

    @Override
    protected SingleSpecification getMatchingSpec(String tag, VariableField f) {
        for (SingleSpecification spec : this.pieces) {
            SingleSpecification thatMatches = spec.getMatchingSpec(tag, f);
            if (thatMatches == null) continue;
            return thatMatches;
        }
        return null;
    }

    @Override
    public void addFieldValues(Collection<String> result, VariableField vf) throws Exception {
        for (SingleSpecification spec : this.pieces) {
            spec.addFieldValues(result, vf);
        }
    }

    @Override
    public void addMap(AbstractMultiValueMapping valueMapping) {
        for (SingleSpecification spec : this.pieces) {
            spec.addMap(valueMapping);
        }
    }

    @Override
    public void setFormatter(FieldFormatter fmt) {
        for (SingleSpecification spec : this.pieces) {
            spec.setFormatter(fmt);
        }
    }

    @Override
    public void addCleanVal(FieldFormatter.eCleanVal cleanVal) {
        for (SingleSpecification spec : this.pieces) {
            spec.addCleanVal(cleanVal);
        }
    }

    @Override
    public void setCleanVal(EnumSet<FieldFormatter.eCleanVal> of) {
        for (SingleSpecification spec : this.pieces) {
            spec.setCleanVal(of);
        }
    }

    @Override
    public void setJoinVal(FieldFormatter.eJoinVal joinVal) {
        for (SingleSpecification spec : this.pieces) {
            spec.setJoinVal(joinVal);
        }
    }

    @Override
    public void setSubstring(int offset, int endOffset) {
        for (SingleSpecification spec : this.pieces) {
            spec.setSubstring(offset, endOffset);
        }
    }

    @Override
    public void setSeparator(String separator) {
        for (SingleSpecification spec : this.pieces) {
            spec.setSeparator(separator);
        }
    }

    @Override
    public void setFormatPatterns(String[] mapParts) {
        for (SingleSpecification spec : this.pieces) {
            spec.setFormatPatterns(mapParts);
        }
    }

    @Override
    public boolean isThreadSafe() {
        for (SingleSpecification spec : this.pieces) {
            if (spec.isThreadSafe()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new CompositeSpecification(this);
    }

    @Override
    public boolean conditionalMatches(Record record, VariableField vf) {
        throw new RuntimeException("invalid invocation of conditionMatches on CompositeSpecification");
    }
}

