/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.specification;

import org.marc4j.marc.impl.Verifier;
import org.solrmarc.index.specification.SingleControlFieldSpecification;
import org.solrmarc.index.specification.SingleDataFieldSpecification;
import org.solrmarc.index.specification.SingleLinkedDataFieldSpecification;
import org.solrmarc.index.specification.SingleSpecification;
import org.solrmarc.index.specification.conditional.Condition;

public class AbstractSpecificationFactory {
    public static boolean canHandle(String indexConfiguration) {
        return indexConfiguration.matches("[{]*(LNK)?[0-9][0-9][0-9].*");
    }

    public static SingleSpecification makeSingleSpecification(String tag, String subfields) {
        return AbstractSpecificationFactory.makeSingleSpecification(tag, subfields, null, null);
    }

    public static SingleSpecification makeSingleSpecification(String tag, String subfields, String position) {
        return AbstractSpecificationFactory.makeSingleSpecification(tag, subfields, position, null);
    }

    public static SingleSpecification makeSingleSpecification(String tag, String subfields, String position, Condition cond) {
        SingleSpecification spec = Verifier.isControlField((String)tag) ? new SingleControlFieldSpecification(tag, cond) : (tag.startsWith("LNK") ? new SingleLinkedDataFieldSpecification(tag, subfields, cond) : new SingleDataFieldSpecification(tag, subfields, cond));
        if (position == null || position.length() == 0) {
            return spec;
        }
        try {
            int offset = Integer.parseInt(position.replaceAll("\\[([0-9]+)(-[0-9]+)?\\]", "$1"));
            String endOffsetStr = position.replaceAll("\\[([0-9]+)(-)?([0-9]+)?\\]", "$3");
            int endOffset = offset;
            if (endOffsetStr != null && endOffsetStr.length() > 0) {
                endOffset = Integer.parseInt(endOffsetStr);
            }
            spec.setSubstring(offset, endOffset + 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return spec;
    }
}

