/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.mapping.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.mapping.AbstractValueMappingFactory;
import org.solrmarc.index.mapping.impl.MultiValueTranslationMapping;
import org.solrmarc.index.mapping.impl.PatternMappingFactory;
import org.solrmarc.tools.PropertyUtils;

public class TranslationMappingFactory
extends AbstractValueMappingFactory {
    private static final Logger logger = Logger.getLogger(TranslationMappingFactory.class);
    private static final Map<String, Properties> translationMappingFiles = new HashMap<String, Properties>();

    @Override
    public boolean canHandle(String mappingConfiguration) {
        return mappingConfiguration.endsWith(".properties") || mappingConfiguration.contains(".properties(") && mappingConfiguration.endsWith(")") || mappingConfiguration.endsWith(".xml") || mappingConfiguration.endsWith(".XML");
    }

    private Properties loadTranslationMappingFile(String translationMappingFileName, String subMappingName) {
        if (translationMappingFileName.equals("(this).properties")) {
            Properties props = ValueIndexerFactory.instance().getLocalMappingProperties();
            props = this.getSubTranslationMapping(props, subMappingName);
            return props;
        }
        Properties properties = translationMappingFiles.get(translationMappingFileName + "(" + subMappingName + ")");
        if (properties != null) {
            return properties;
        }
        properties = translationMappingFiles.get(translationMappingFileName + "(null)");
        if (properties != null) {
            properties = this.getSubTranslationMapping(properties, subMappingName);
            translationMappingFiles.put(translationMappingFileName + "(" + subMappingName + ")", properties);
            return properties;
        }
        String[] filenameOpened = new String[]{null};
        properties = PropertyUtils.loadProperties(ValueIndexerFactory.instance().getHomeDirs(), "translation_maps" + File.separator + translationMappingFileName, filenameOpened);
        logger.debug((Object)("Load translation map: " + translationMappingFileName + " from file : " + filenameOpened[0]));
        translationMappingFiles.put(translationMappingFileName + "(null)", properties);
        if (subMappingName != null) {
            properties = this.getSubTranslationMapping(properties, subMappingName);
            translationMappingFiles.put(translationMappingFileName + "(" + subMappingName + ")", properties);
        }
        return properties;
    }

    private Properties getSubTranslationMapping(Properties translationMapping, String mappingPrefix) {
        Properties mappings = new Properties();
        for (String key : translationMapping.stringPropertyNames()) {
            if (!key.startsWith(mappingPrefix + ".")) continue;
            String value = translationMapping.getProperty(key);
            if (key.length() == mappingPrefix.length()) {
                mappings.setProperty("", value);
                continue;
            }
            mappings.setProperty(key.substring(mappingPrefix.length() + 1), value);
        }
        return mappings;
    }

    private String getTranslationMappingFileName(String mappingConfiguration) {
        if (mappingConfiguration.equals("(this).properties")) {
            return mappingConfiguration;
        }
        int index = mappingConfiguration.indexOf(40);
        if (index != -1) {
            return mappingConfiguration.substring(0, index);
        }
        return mappingConfiguration;
    }

    private String getSubMappingName(String mappingConfiguration) {
        int index = mappingConfiguration.indexOf(40);
        if (index != -1) {
            return mappingConfiguration.substring(index + 1, mappingConfiguration.length() - 1);
        }
        return null;
    }

    private String getMappingConfigurationName(String[] mapParts) {
        String configuration = mapParts[0] + (mapParts.length > 1 ? "(" + mapParts[1] + ")" : "");
        return configuration;
    }

    @Override
    public AbstractMultiValueMapping createMultiValueMapping(String mappingConfiguration) {
        String subMappingName;
        String translationMappingFileName = this.getTranslationMappingFileName(mappingConfiguration);
        Properties translationMapping = this.loadTranslationMappingFile(translationMappingFileName, subMappingName = this.getSubMappingName(mappingConfiguration));
        if (translationMapping.containsKey("pattern_0")) {
            return PatternMappingFactory.patternMappingsFromPatternProperties(mappingConfiguration, translationMapping);
        }
        return new MultiValueTranslationMapping(mappingConfiguration, translationMapping);
    }

    @Override
    public AbstractMultiValueMapping createMultiValueMapping(String[] mapParts) {
        String translationMappingFileName = this.getTranslationMappingFileName(mapParts[0]);
        String subMappingName = mapParts.length > 1 ? mapParts[1] : null;
        Properties translationMapping = this.loadTranslationMappingFile(translationMappingFileName, subMappingName);
        String mappingConfiguration = this.getMappingConfigurationName(mapParts);
        if (translationMapping.containsKey("pattern_0")) {
            return PatternMappingFactory.patternMappingsFromPatternProperties(mappingConfiguration, translationMapping);
        }
        return new MultiValueTranslationMapping(mappingConfiguration, translationMapping);
    }
}

