/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.mapping.impl;

import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import org.solrmarc.index.extractor.impl.patternMapping.PatternMapping;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.mapping.AbstractValueMappingFactory;
import org.solrmarc.index.mapping.impl.MultiValuePatternMapping;

public class PatternMappingFactory
extends AbstractValueMappingFactory {
    @Override
    public boolean canHandle(String mappingConfiguration) {
        return mappingConfiguration.equals("map") || mappingConfiguration.equals("filter");
    }

    @Override
    public AbstractMultiValueMapping createMultiValueMapping(String mappingConfiguration) {
        int parenLoc = mappingConfiguration.indexOf("(");
        return PatternMappingFactory.getMultiValuePatternMappingsFromString(mappingConfiguration.substring(0, parenLoc), mappingConfiguration.substring(parenLoc + 1, mappingConfiguration.length() - 1));
    }

    @Override
    public AbstractMultiValueMapping createMultiValueMapping(String[] mapParts) {
        if (mapParts.length > 2) {
            return PatternMappingFactory.getMultiValuePattermMappingsFromStrings(mapParts[0], mapParts, 1);
        }
        return PatternMappingFactory.getMultiValuePatternMappingsFromString(mapParts[0], mapParts[1]);
    }

    public static MultiValuePatternMapping getMultiValuePatternMappingsFromString(String mapType, String mapSpec) {
        String[] mapParts = mapSpec.split("[|][|]");
        return PatternMappingFactory.getMultiValuePattermMappingsFromStrings(mapType, mapParts, 0);
    }

    public static MultiValuePatternMapping getMultiValuePattermMappingsFromStrings(String mapType, String[] mapParts, int offset) {
        ArrayList<PatternMapping> pm = new ArrayList<PatternMapping>(mapParts.length);
        boolean filter = mapType.equals("filter");
        boolean matchAll = filter;
        boolean keepRaw = filter;
        for (int i = offset; i < mapParts.length; ++i) {
            String[] mapEntry = mapParts[i].split("[ ]*=>[ ]*", 2);
            if (mapEntry.length == 2) {
                mapEntry[0] = mapEntry[0].replaceAll("\\\\(.)", "$1");
                try {
                    pm.add(new PatternMapping(mapEntry[0], mapEntry[1], i));
                    continue;
                }
                catch (PatternSyntaxException pse) {
                    throw new IndexerSpecException("Malformed regular expression in pattern map : " + mapEntry[0] + "\n" + pse.getMessage());
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new IndexerSpecException("Unknown group in replacement string : " + mapEntry[1] + "\n" + ioobe.getMessage());
                }
            }
            if (mapEntry.length == 1 && mapEntry[0].equals("filter")) {
                filter = true;
                continue;
            }
            if (mapEntry.length == 1 && mapEntry[0].equals("matchAll")) {
                matchAll = true;
                continue;
            }
            if (mapEntry.length != 1 || !mapEntry[0].equals("keepRaw")) continue;
            keepRaw = true;
        }
        return new MultiValuePatternMapping("local", pm, filter, matchAll, keepRaw);
    }

    public static MultiValuePatternMapping patternMappingsFromPatternProperties(String mappingName, Properties props) {
        ArrayList<PatternMapping> pm = new ArrayList<PatternMapping>(props.size());
        boolean filter = false;
        boolean matchAll = false;
        boolean keepRaw = false;
        for (int i = 0; i < props.size(); ++i) {
            String key = "pattern_" + i;
            String value = props.getProperty(key);
            String[] mapEntry = value.split("[ ]*=>[ ]*", 2);
            if (mapEntry.length == 2) {
                try {
                    pm.add(new PatternMapping(mapEntry[0], mapEntry[1], i));
                    continue;
                }
                catch (PatternSyntaxException pse) {
                    throw new IndexerSpecException("Malformed regular expression in pattern map : " + mapEntry[0] + "\n" + pse.getMessage());
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new IndexerSpecException("Unknown group in replacement string : " + mapEntry[1] + "\n" + ioobe.getMessage());
                }
            }
            if (mapEntry.length == 1 && mapEntry[0].equals("filter")) {
                filter = true;
                continue;
            }
            if (mapEntry.length == 1 && mapEntry[0].equals("matchAll")) {
                matchAll = true;
                continue;
            }
            if (mapEntry.length != 1 || !mapEntry[0].equals("keepRaw")) continue;
            keepRaw = true;
        }
        return new MultiValuePatternMapping(mappingName, pm, filter, matchAll, keepRaw);
    }
}

