/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;

public class MultiValueTranslationMapping
extends AbstractMultiValueMapping {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[|]");
    private final String mapName;
    private final Properties translationMapping;
    private final String defaultValue;
    private boolean displayRaw = false;
    private boolean exceptionIfMissing = false;

    public MultiValueTranslationMapping(String mapName, Properties translationMapping) {
        String exception;
        String defaultKey;
        this.mapName = mapName;
        this.translationMapping = translationMapping;
        String property = null;
        String[] stringArray = DEFAULT_KEYS;
        int n = stringArray.length;
        for (int i = 0; i < n && (property = translationMapping.getProperty(defaultKey = stringArray[i])) == null; ++i) {
        }
        String dRaw = translationMapping.getProperty("displayRawIfMissing");
        if (dRaw != null && dRaw.equals("true")) {
            this.displayRaw = true;
        }
        if ((exception = translationMapping.getProperty("throwExceptionIfMissing")) != null && exception.equals("true")) {
            this.exceptionIfMissing = true;
        }
        this.defaultValue = property;
    }

    @Override
    public Collection<String> map(Collection<String> values) {
        ArrayList<String> mappedValues = new ArrayList<String>(values.size());
        for (String value : values) {
            String translation;
            String string = translation = value == null ? this.defaultValue : this.translationMapping.getProperty(value, this.defaultValue);
            if (translation != null && !translation.equals("null")) {
                if (translation.contains("|")) {
                    String[] translationParts = SEPARATOR_PATTERN.split(translation);
                    Collections.addAll(mappedValues, translationParts);
                    continue;
                }
                mappedValues.add(translation);
                continue;
            }
            if (this.displayRaw) {
                mappedValues.add(value);
                continue;
            }
            if (!this.exceptionIfMissing) continue;
            ValueIndexerFactory.instance().addPerRecordError(new IndexerSpecException(IndexerSpecException.eErrorSeverity.WARN, "Undefined value '" + value + "' for translation map: " + this.mapName));
        }
        return mappedValues;
    }

    @Override
    public boolean ifApplies(char subfieldCode) {
        return true;
    }
}

