/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.solrmarc.index.extractor.impl.patternMapping.PatternMapping;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;

public class MultiValuePatternMapping
extends AbstractMultiValueMapping {
    private final String mappingName;
    private final List<PatternMapping> patternMappings;
    private final boolean filter;
    private final boolean applyAll;
    private final boolean keepRaw;

    public MultiValuePatternMapping(String mappingName, List<PatternMapping> patternMappings, boolean filter, boolean applyAll, boolean keepRaw) {
        this.mappingName = mappingName;
        this.patternMappings = patternMappings;
        this.filter = filter;
        this.applyAll = applyAll;
        this.keepRaw = keepRaw;
    }

    public MultiValuePatternMapping(String mappingName, List<PatternMapping> patternMappings) {
        this.mappingName = mappingName;
        this.patternMappings = patternMappings;
        this.filter = false;
        this.applyAll = false;
        this.keepRaw = false;
    }

    @Override
    public Collection<String> map(Collection<String> values) {
        ArrayList<String> mappedValues = new ArrayList<String>(values.size());
        if (this.filter) {
            if (this.applyAll) {
                for (String value : values) {
                    if ((value = PatternMapping.filterSingleValue(this.patternMappings, value)) == null || value.length() <= 0) continue;
                    mappedValues.add(value);
                }
            } else {
                for (String value : values) {
                    PatternMapping.filterValues(this.patternMappings, value, mappedValues);
                }
            }
        } else if (this.applyAll) {
            for (String value : values) {
                if ((value = PatternMapping.mapSingleValue(this.patternMappings, value)) == null || value.length() <= 0) continue;
                mappedValues.add(value);
            }
        } else {
            for (String value : values) {
                PatternMapping.mapValues(this.patternMappings, value, mappedValues);
            }
        }
        if (mappedValues.size() == 0 && this.keepRaw) {
            mappedValues.addAll(values);
        }
        return mappedValues;
    }

    @Override
    public boolean ifApplies(char subfieldCode) {
        return true;
    }
}

