/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.indexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.marc4j.marc.Record;
import org.solrmarc.driver.Boot;
import org.solrmarc.index.collector.MultiValueCollector;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.AbstractSingleValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.formatter.FieldFormatter;
import org.solrmarc.index.extractor.impl.direct.ModifyableMultiValueExtractor;
import org.solrmarc.index.extractor.impl.java.JavaValueExtractorUtils;
import org.solrmarc.index.extractor.methodcall.MethodCallManager;
import org.solrmarc.index.extractor.methodcall.StaticMarcTestRecords;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.indexer.FullConditionalParser;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.MultiValueIndexer;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.mapping.AbstractValueMappingFactory;
import org.solrmarc.index.utils.ClasspathUtils;
import org.solrmarc.tools.DataUtil;
import org.solrmarc.tools.SolrMarcIndexerException;
import org.solrmarc.tools.Utils;

public class ValueIndexerFactory {
    private static final Logger logger = Logger.getLogger(ValueIndexerFactory.class);
    private List<AbstractValueExtractorFactory> extractorFactories;
    private List<AbstractValueMappingFactory> mappingFactories;
    private List<IndexerSpecException> validationExceptions;
    private ThreadLocal<Set<IndexerSpecException>> perRecordExceptions;
    private FullConditionalParser parser = null;
    private Properties localMappingProperties = null;
    private JavaValueExtractorUtils compileTool = null;
    private String[] homeDirStrs = null;
    private final Pattern specPattern = Pattern.compile("([-A-Za-z_0-9, \\t]*)([:=]|([+?|]=))(.*)");
    boolean debug_parse = true;
    private boolean defaultUniqueVal = true;
    private String defaultCustomClassname = null;
    private final Pattern defaultUniquePattern = Pattern.compile("default.unique[ ]*[;=][ ]*[\"]?(true|false)[\"]?");
    private final Pattern defaultCustomClassPattern = Pattern.compile("default.customClass[ ]*[;=][ ]*[\"]?([a-z][A-Za-z0-9.]+[a-zA-Z0-9])[\"]?");
    private static ValueIndexerFactory theFactory = null;

    public static ValueIndexerFactory initialize(String[] homeDirStrs) {
        if (homeDirStrs == null) {
            homeDirStrs = new String[]{"."};
        }
        if (theFactory != null && Arrays.equals(homeDirStrs, ValueIndexerFactory.theFactory.homeDirStrs)) {
            return theFactory;
        }
        theFactory = new ValueIndexerFactory(homeDirStrs);
        try {
            ValueIndexerFactory.theFactory.extractorFactories = theFactory.createExtractorFactories(ClasspathUtils.instance().getExtractorFactoryClasses());
            ValueIndexerFactory.theFactory.mappingFactories = theFactory.createMappingFactories(ClasspathUtils.instance().getMappingFactoryClasses());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IndexerSpecException(e, "Error creating extractor or mapping factories");
        }
        return theFactory;
    }

    public static ValueIndexerFactory instance() {
        return theFactory;
    }

    public ValueIndexerFactory(String[] homeDirStrs) {
        this.homeDirStrs = homeDirStrs;
        this.perRecordExceptions = new ThreadLocal<Set<IndexerSpecException>>(){

            @Override
            protected Set<IndexerSpecException> initialValue() {
                return new LinkedHashSet<IndexerSpecException>();
            }
        };
        ArrayList<String> dirsJavaSourceList = new ArrayList<String>();
        for (String dirStr : homeDirStrs) {
            File dir = new File(dirStr);
            File dirIndexJava = new File(dirStr, "index_java");
            File dirIndexJavaSrc = new File(dirIndexJava, "src");
            if (!dirIndexJava.exists() || !dirIndexJavaSrc.exists()) continue;
            logger.info((Object)("Using directory: " + dirIndexJava.getAbsolutePath() + " as location of java sources"));
            dirsJavaSourceList.add(dir.getAbsolutePath());
        }
        String[] dirsJavaSource = dirsJavaSourceList.toArray(new String[0]);
        this.compileTool = new JavaValueExtractorUtils(dirsJavaSource);
        try {
            this.compileTool.compileSources(false);
            this.compileTool.getClasses();
        }
        catch (UnsupportedClassVersionError ucve) {
            this.compileTool.compileSources(true);
        }
    }

    public Class<?>[] getCompiledClasses() {
        return this.compileTool.getClasses();
    }

    public List<IndexerSpecException> getValidationExceptions() {
        return this.validationExceptions;
    }

    public void addPerRecordError(IndexerSpecException error) {
        this.perRecordExceptions.get().add(error);
    }

    public String getDefaultCustomClassname() {
        return this.defaultCustomClassname;
    }

    final List<AbstractValueExtractorFactory> getExtractorFactories() {
        return this.extractorFactories;
    }

    public Set<IndexerSpecException> getPerRecordErrors() {
        return this.perRecordExceptions.get();
    }

    public void clearPerRecordErrors() {
        this.perRecordExceptions.get().clear();
    }

    public Properties getLocalMappingProperties() {
        return this.localMappingProperties;
    }

    public List<AbstractValueIndexer<?>> createValueIndexers(File[] indexSpecFiles) throws IllegalAccessException, InstantiationException, IOException {
        this.localMappingProperties = new Properties();
        LinkedHashMap valueIndexerMap = new LinkedHashMap();
        LinkedHashMap<String, List<IndexerSpecException>> valueIndexerExceptions = new LinkedHashMap<String, List<IndexerSpecException>>();
        this.createValueIndexers(indexSpecFiles, valueIndexerMap, valueIndexerExceptions);
        List<AbstractValueIndexer<?>> valueIndexers = this.collapseMapToList(valueIndexerMap);
        this.validationExceptions = this.collapseExceptionsMaptoList(valueIndexerExceptions);
        return valueIndexers;
    }

    public List<AbstractValueIndexer<?>> createValueIndexers(String[] configSpecs) throws IllegalAccessException, InstantiationException {
        this.localMappingProperties = new Properties();
        LinkedHashMap valueIndexerMap = new LinkedHashMap();
        LinkedHashMap<String, List<IndexerSpecException>> valueIndexerExceptions = new LinkedHashMap<String, List<IndexerSpecException>>();
        this.createValueIndexers(configSpecs, valueIndexerMap, valueIndexerExceptions);
        List<AbstractValueIndexer<?>> valueIndexers = this.collapseMapToList(valueIndexerMap);
        this.validationExceptions = this.collapseExceptionsMaptoList(valueIndexerExceptions);
        return valueIndexers;
    }

    private List<AbstractValueIndexer<?>> collapseMapToList(Map<String, List<AbstractValueIndexer<?>>> valueIndexerMap) {
        ArrayList valueIndexers = new ArrayList();
        for (List<AbstractValueIndexer<?>> indexer : valueIndexerMap.values()) {
            valueIndexers.addAll(indexer);
        }
        return valueIndexers;
    }

    private List<IndexerSpecException> collapseExceptionsMaptoList(Map<String, List<IndexerSpecException>> valueIndexerExceptions) {
        ArrayList<IndexerSpecException> valueIndexers = new ArrayList<IndexerSpecException>();
        for (List<IndexerSpecException> indexer : valueIndexerExceptions.values()) {
            valueIndexers.addAll(indexer);
        }
        return valueIndexers;
    }

    private void createValueIndexers(File[] indexSpecFiles, Map<String, List<AbstractValueIndexer<?>>> valueIndexerMap, Map<String, List<IndexerSpecException>> valueIndexerExceptions) throws IllegalAccessException, InstantiationException, IOException {
        for (File indexSpecFile : indexSpecFiles) {
            this.createValueIndexers(indexSpecFile, valueIndexerMap, valueIndexerExceptions);
        }
    }

    private void createValueIndexers(File indexSpecFile, Map<String, List<AbstractValueIndexer<?>>> valueIndexerMap, Map<String, List<IndexerSpecException>> valueIndexerExceptions) throws IllegalAccessException, InstantiationException, IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(indexSpecFile));
        String saveLine = "";
        while ((line = reader.readLine()) != null) {
            if (saveLine.length() > 0 && line.matches("^[ \t].*")) {
                line = saveLine + line;
                saveLine = "";
            }
            if (line.matches(".*,[ \t]*$")) {
                saveLine = line;
                continue;
            }
            lines.add(line);
        }
        if (saveLine.length() > 0) {
            lines.add(saveLine);
        }
        this.createValueIndexers(lines.toArray(new String[0]), valueIndexerMap, valueIndexerExceptions);
        reader.close();
    }

    private void createValueIndexers(String[] configSpecs, Map<String, List<AbstractValueIndexer<?>>> valueIndexerMap, Map<String, List<IndexerSpecException>> valueIndexerExceptions) throws IllegalAccessException, InstantiationException {
        this.defaultCustomClassname = null;
        for (String singleSpec : configSpecs) {
            String[] specParts;
            if (!singleSpec.startsWith("map.") && !singleSpec.startsWith("pattern_map.") && !singleSpec.startsWith("solrmarc.") || (specParts = singleSpec.split("[ ]?[:=][ ]?", 2)).length < 2) continue;
            if (specParts[0].startsWith("solrmarc.")) {
                if (System.getProperty(specParts[0]) != null) continue;
                System.setProperty(specParts[0], specParts[1]);
                continue;
            }
            specParts[1] = specParts[1].replaceAll("\\\\(.)", "$1");
            this.localMappingProperties.put(specParts[0].trim(), specParts[1].trim());
        }
        for (String singleSpec : configSpecs) {
            Matcher match;
            if ((singleSpec = singleSpec.trim()).startsWith("#") || !singleSpec.contains(":") && !singleSpec.contains("=") || singleSpec.startsWith("map.") || singleSpec.startsWith("pattern_map.") || singleSpec.startsWith("solrmarc.")) continue;
            if (singleSpec.startsWith("default")) {
                Matcher defClass;
                if (singleSpec.startsWith("default.unique")) {
                    Matcher defUnique = this.defaultUniquePattern.matcher(singleSpec);
                    if (defUnique.matches()) {
                        this.defaultUniqueVal = Boolean.parseBoolean(defUnique.group(1));
                    }
                } else if (singleSpec.startsWith("default.customClass") && (defClass = this.defaultCustomClassPattern.matcher(singleSpec)).matches()) {
                    this.defaultCustomClassname = defClass.group(1);
                }
            }
            if (!(match = this.specPattern.matcher(singleSpec)).matches()) continue;
            String solrFieldName = match.group(1).replaceAll("[ \\t]", "");
            String delimiter = match.group(2);
            String mappingDefinition = match.group(4);
            try {
                MultiValueIndexer valueIndexer = this.createValueIndexer(solrFieldName, mappingDefinition);
                List<Object> exceptions = delimiter.startsWith("+") && valueIndexerExceptions.containsKey(solrFieldName) ? valueIndexerExceptions.get(solrFieldName) : new ArrayList();
                if (valueIndexer != null) {
                    List<Object> indexerList = (delimiter.startsWith("+") || delimiter.startsWith("|") || delimiter.startsWith("?")) && valueIndexerMap.containsKey(solrFieldName) ? valueIndexerMap.get(solrFieldName) : new ArrayList();
                    if (delimiter.startsWith("?")) {
                        valueIndexer.setIfEmpty();
                    }
                    if (delimiter.startsWith("|")) {
                        valueIndexer.setIfUnique();
                    }
                    indexerList.add(valueIndexer);
                    valueIndexerMap.put(solrFieldName, indexerList);
                }
                for (IndexerSpecException ise : FullConditionalParser.getErrors()) {
                    ise.setSolrFieldAndSpec(solrFieldName, mappingDefinition);
                    exceptions.add(ise);
                }
                valueIndexerExceptions.put(solrFieldName, exceptions);
            }
            catch (IndexerSpecException ise) {
                ise.setSolrFieldAndSpec(solrFieldName, mappingDefinition);
                valueIndexerExceptions.put(solrFieldName, Collections.singletonList(ise));
            }
        }
    }

    public MultiValueIndexer createValueIndexer(String fieldNames, String indexSpec) {
        boolean testFileMethod;
        if (this.parser == null) {
            try {
                this.parser = new FullConditionalParser(this.debug_parse);
                this.parser.setFactories(this);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        logger.trace((Object)("Processing spec: " + indexSpec));
        MultiValueIndexer valueIndexer = this.parser.parse(fieldNames, indexSpec);
        if (valueIndexer != null && (testFileMethod = Boolean.parseBoolean(System.getProperty("solrmarc.indexer.test.fire.method", "false")))) {
            try {
                logger.trace((Object)("Test firing spec: " + indexSpec));
                valueIndexer.getFieldData(StaticMarcTestRecords.testRecord[0]);
            }
            catch (SolrMarcIndexerException solrMarcIndexerException) {
            }
            catch (InvocationTargetException ite) {
                throw new IndexerSpecException(ite.getTargetException(), "Error on test invocation of custom method: " + indexSpec);
            }
            catch (Exception e) {
                try {
                    Class<?> targetErrorClazz = Boot.classForName("bsh.TargetError");
                    if (targetErrorClazz.isInstance(e)) {
                        throw new IndexerSpecException(e, "Error on test invocation of custom script method: " + indexSpec);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                throw new IndexerSpecException(e, "Error on test invocation of custom method: " + indexSpec);
            }
        }
        return valueIndexer;
    }

    public static AbstractValueIndexer<?> makeThreadSafeCopy(AbstractValueIndexer<?> toClone) {
        String solrFieldNamesStr = toClone.getSolrFieldNamesStr();
        String specLabel = toClone.getSpecLabel();
        MultiValueCollector collector = toClone.collector;
        AtomicLong totalElapsedTime = toClone.totalElapsedTime;
        AbstractMultiValueMapping[] mappings = new AbstractMultiValueMapping[toClone.mappings.length];
        for (int i = 0; i < toClone.mappings.length; ++i) {
            mappings[i] = toClone.mappings[i] instanceof ExternalMethod && !((ExternalMethod)((Object)toClone.mappings[i])).isThreadSafe() ? (AbstractMultiValueMapping)((ExternalMethod)((Object)toClone.mappings[i])).makeThreadSafeCopy() : (AbstractMultiValueMapping)toClone.mappings[i];
        }
        AbstractMultiValueExtractor extractor = toClone.extractor instanceof ExternalMethod && !((ExternalMethod)((Object)toClone.extractor)).isThreadSafe() ? (AbstractMultiValueExtractor)((ExternalMethod)((Object)toClone.extractor)).makeThreadSafeCopy() : (AbstractMultiValueExtractor)toClone.extractor;
        MultiValueIndexer result = new MultiValueIndexer(solrFieldNamesStr, extractor, mappings, collector, specLabel, totalElapsedTime);
        if (toClone.getOnlyIfEmpty()) {
            result.setIfEmpty();
        }
        if (toClone.getOnlyIfUnique()) {
            result.setIfUnique();
        }
        return result;
    }

    private List<AbstractValueExtractorFactory> createExtractorFactories(Set<Class<? extends AbstractValueExtractorFactory>> factoryClasses) throws IllegalAccessException, InstantiationException {
        ArrayList<AbstractValueExtractorFactory> factories = new ArrayList<AbstractValueExtractorFactory>(factoryClasses.size());
        for (Class<? extends AbstractValueExtractorFactory> extractorFactoryClass : factoryClasses) {
            if (Modifier.isAbstract(extractorFactoryClass.getModifiers())) continue;
            logger.trace((Object)("Create value extractor factory for " + extractorFactoryClass));
            try {
                AbstractValueExtractorFactory factory = extractorFactoryClass.newInstance();
                factories.add(factory);
            }
            catch (ClassCastException classCastException) {}
        }
        return factories;
    }

    private List<AbstractValueMappingFactory> createMappingFactories(Set<Class<? extends AbstractValueMappingFactory>> factoryClasses) throws IllegalAccessException, InstantiationException {
        ArrayList<AbstractValueMappingFactory> factories = new ArrayList<AbstractValueMappingFactory>(factoryClasses.size());
        for (Class<? extends AbstractValueMappingFactory> extractorFactoryClass : factoryClasses) {
            logger.trace((Object)("Create value mapping factory for  s " + extractorFactoryClass));
            try {
                AbstractValueMappingFactory factory = extractorFactoryClass.newInstance();
                factories.add(factory);
            }
            catch (ClassCastException classCastException) {}
        }
        return factories;
    }

    AbstractValueIndexer<?> makeMultiValueIndexer(String origSpec, String fieldnames, AbstractValueExtractor<?> extractor, List<List<String>> mapSpecs, List<IndexerSpecException> currentExceptions) {
        if (mapSpecs == null) {
            mapSpecs = new ArrayList<List<String>>();
        }
        if (extractor instanceof ModifyableMultiValueExtractor) {
            int indexOfJoin = this.decorateMultiValueExtractor(origSpec, fieldnames, (ModifyableMultiValueExtractor)((Object)extractor), mapSpecs, currentExceptions);
            List<Object> mappings = indexOfJoin != -1 ? this.createMultiValueMappings(origSpec, mapSpecs, indexOfJoin, currentExceptions) : new ArrayList();
            MultiValueCollector collector = this.createMultiValueCollector(mapSpecs, true);
            return new MultiValueIndexer(fieldnames, (AbstractMultiValueExtractor)extractor, mappings, collector);
        }
        if (extractor instanceof AbstractMultiValueExtractor) {
            AbstractMultiValueExtractor multiValueExtractor = (AbstractMultiValueExtractor)extractor;
            List<AbstractMultiValueMapping> mappings = this.createMultiValueMappings(origSpec, mapSpecs, currentExceptions);
            MultiValueCollector collector = this.createMultiValueCollector(mapSpecs);
            return new MultiValueIndexer(fieldnames, multiValueExtractor, mappings, collector);
        }
        if (extractor instanceof AbstractSingleValueExtractor) {
            AbstractSingleValueExtractor singleValueExtractor = (AbstractSingleValueExtractor)extractor;
            List<AbstractMultiValueMapping> mappings = this.createMultiValueMappings(origSpec, mapSpecs, currentExceptions);
            MultiValueCollector collector = this.createMultiValueCollector(mapSpecs);
            return new MultiValueIndexer(fieldnames, singleValueExtractor, mappings, collector);
        }
        if (extractor == null) {
            throw new IllegalArgumentException("Extractor is null, most likely there was an error parsing the index specification: " + origSpec);
        }
        throw new IllegalArgumentException("Only subclasses of AbstractMultiValueExtractor or AbstractSingleValueExtractor are allowed, but not " + extractor.getClass().getName());
    }

    boolean isADecoratorConfiguration(String str) {
        return str.equals("join") || str.equals("separate") || str.equals("format") || str.equals("substring") || str.equals("cleanEach") || str.equals("cleanEnd") || str.equals("clean") || str.equals("stripAccent") || str.equals("stripPunct") || str.equals("stripInd1") || str.equals("stripInd2") || str.equals("stripInd") || str.equals("toUpper") || str.equals("toLower") || str.equals("titleSortUpper") || str.equals("titleSortLower") || str.equals("untrimmed") || str.equals("toTitleCase");
    }

    private int decorateMultiValueExtractor(String origSpec, String fieldnames, ModifyableMultiValueExtractor multiValueExtractor, List<List<String>> mapSpecs, List<IndexerSpecException> currentExceptions) {
        if (mapSpecs.size() == 0) {
            return -1;
        }
        int currentIndex = 0;
        int joinIndex = -1;
        for (List<String> mapSpec : mapSpecs) {
            block21: {
                String[] mapParts = mapSpec.toArray(new String[0]);
                if (!this.isACollectorConfiguration(mapParts[0])) {
                    if (mapParts[0].equals("join")) {
                        multiValueExtractor.setJoinVal(FieldFormatter.eJoinVal.JOIN);
                        if (mapParts.length > 1) {
                            multiValueExtractor.setSeparator(mapParts[1]);
                        }
                        joinIndex = currentIndex;
                    } else if (mapParts[0].equals("separate")) {
                        multiValueExtractor.setJoinVal(FieldFormatter.eJoinVal.SEPARATE);
                    } else if (mapParts[0].equals("format")) {
                        if (mapParts.length > 1) {
                            multiValueExtractor.setFormatPatterns(mapParts);
                        }
                    } else if (mapParts[0].equals("substring")) {
                        try {
                            if (mapParts.length > 2) {
                                multiValueExtractor.setSubstring(mapParts[1], mapParts[2]);
                                break block21;
                            }
                            multiValueExtractor.setSubstring(mapParts[1], "toEnd");
                        }
                        catch (IndexerSpecException ise) {
                            ise.setSolrFieldAndSpec(fieldnames, origSpec);
                            currentExceptions.add(ise);
                        }
                    } else if (this.isAValueMappingConfiguration(mapParts[0]) && joinIndex == -1) {
                        AbstractMultiValueMapping valueMapping = this.createMultiValueMapping(mapParts);
                        multiValueExtractor.addMap(valueMapping);
                    } else if (!this.isAValueMappingConfiguration(mapParts[0]) || joinIndex == -1) {
                        EnumSet<FieldFormatter.eCleanVal> tmpVal = DataUtil.getCleanValForParam(mapParts[0]);
                        if (tmpVal != EnumSet.noneOf(FieldFormatter.eCleanVal.class)) {
                            multiValueExtractor.setCleanVal(tmpVal);
                        } else {
                            currentExceptions.add(new IndexerSpecException(fieldnames, origSpec, "Illegal format specification: " + Utils.join(mapParts, " ")));
                        }
                    }
                }
            }
            ++currentIndex;
        }
        return joinIndex;
    }

    private boolean isAValueMappingConfiguration(String configuration) {
        for (AbstractValueMappingFactory mappingFactory : this.mappingFactories) {
            if (!mappingFactory.canHandle(configuration)) continue;
            return true;
        }
        return false;
    }

    private List<AbstractMultiValueMapping> createMultiValueMappings(String origSpec, List<List<String>> mapSpecs, List<IndexerSpecException> currentExceptions) {
        return this.createMultiValueMappings(origSpec, mapSpecs, -1, currentExceptions);
    }

    private List<AbstractMultiValueMapping> createMultiValueMappings(String origSpec, List<List<String>> mapSpecs, int indexOfJoin, List<IndexerSpecException> currentExceptions) {
        ArrayList<AbstractMultiValueMapping> maps = new ArrayList<AbstractMultiValueMapping>(mapSpecs.size());
        if (mapSpecs.size() == 0) {
            return maps;
        }
        int currentIndex = 0;
        for (List<String> mapSpec : mapSpecs) {
            String[] mapParts;
            if (currentIndex > indexOfJoin && !this.isACollectorConfiguration((mapParts = mapSpec.toArray(new String[0]))[0]) && !this.isADecoratorConfiguration(mapParts[0])) {
                if (this.isAValueMappingConfiguration(mapParts[0])) {
                    AbstractMultiValueMapping valueMapping = this.createMultiValueMapping(mapParts);
                    if (valueMapping != null) {
                        maps.add(valueMapping);
                    }
                } else {
                    currentExceptions.add(new IndexerSpecException(origSpec, "Illegal format specification: " + Utils.join(mapParts, " ")));
                }
            }
            ++currentIndex;
        }
        return maps;
    }

    private boolean isACollectorConfiguration(String string) {
        return string.equals("unique") || string.equals("first") || string.equals("sort") || string.equals("notunique") || string.equals("notfirst") || string.equals("all") || string.equals("DeleteRecordIfFieldEmpty") || string.equals("DeleteRecordIfFieldNotEmpty") || string.equals("SkipRecordIfFieldEmpty") || string.equals("SkipRecordIfFieldNotEmpty") || string.equals("normalize") || string.equals("unnormalize");
    }

    private MultiValueCollector createMultiValueCollector(List<List<String>> mapSpecs, boolean setDefaultValForUnique) {
        MultiValueCollector collector = new MultiValueCollector();
        if (setDefaultValForUnique) {
            collector.setUnique(this.defaultUniqueVal);
        }
        for (List<String> mapSpec : mapSpecs) {
            String[] mapParts = mapSpec.toArray(new String[0]);
            if (!this.isACollectorConfiguration(mapParts[0])) continue;
            if (mapParts[0].equals("unique")) {
                collector.setUnique(true);
                continue;
            }
            if (mapParts[0].equals("notunique")) {
                collector.setUnique(false);
                continue;
            }
            if (mapParts[0].equals("first")) {
                collector.setFirst(mapParts[0]);
                continue;
            }
            if (mapParts[0].equals("notfirst")) {
                collector.setFirst(mapParts[0]);
                continue;
            }
            if (mapParts[0].equals("normalize")) {
                collector.setNormalize("C");
                continue;
            }
            if (mapParts[0].equals("unnormalize")) {
                collector.setNormalize("D");
                continue;
            }
            if (mapParts[0].equals("all")) {
                collector.setFirst(mapParts[0]);
                continue;
            }
            if (mapParts[0].equals("sort")) {
                collector.setSortComparator(mapParts[1], mapParts[2]);
                continue;
            }
            if (mapParts[0].equals("DeleteRecordIfFieldEmpty")) {
                collector.setIfFieldEmpty(MultiValueCollector.eAction.DELETE);
                continue;
            }
            if (mapParts[0].equals("DeleteRecordIfFieldNotEmpty")) {
                collector.setIfFieldNotEmpty(MultiValueCollector.eAction.DELETE);
                continue;
            }
            if (mapParts[0].equals("SkipRecordIfFieldEmpty")) {
                collector.setIfFieldEmpty(MultiValueCollector.eAction.SKIP);
                continue;
            }
            if (!mapParts[0].equals("SkipRecordIfFieldNotEmpty")) continue;
            collector.setIfFieldNotEmpty(MultiValueCollector.eAction.SKIP);
        }
        return collector;
    }

    private MultiValueCollector createMultiValueCollector(List<List<String>> mapSpecs) {
        return this.createMultiValueCollector(mapSpecs, false);
    }

    public AbstractMultiValueMapping createMultiValueMapping(String mappingConfig) {
        for (AbstractValueMappingFactory mappingFactory : this.mappingFactories) {
            if (!mappingFactory.canHandle(mappingConfig)) continue;
            return mappingFactory.createMultiValueMapping(mappingConfig);
        }
        throw new IndexerSpecException("Could not handle impl: " + mappingConfig + "\nLoaded impl factories:\n" + this.mappingFactories.toString().replaceAll(",", ",\n"));
    }

    private AbstractMultiValueMapping createMultiValueMapping(String[] mapParts) {
        for (AbstractValueMappingFactory mappingFactory : this.mappingFactories) {
            if (!mappingFactory.canHandle(mapParts[0])) continue;
            return mappingFactory.createMultiValueMapping(mapParts);
        }
        throw new IndexerSpecException("Could not handle map descriptor: " + Utils.join(mapParts, " "));
    }

    public String[] getHomeDirs() {
        return this.homeDirStrs;
    }

    public void doneWithRecord(Record record) {
        MethodCallManager.instance().doneWithRecord(record);
    }
}

