/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.indexer;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.marc4j.marc.Record;
import org.solrmarc.index.collector.MultiValueCollector;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.AbstractSingleValueExtractor;
import org.solrmarc.index.extractor.MultiValueWrapperSingleValueExtractor;
import org.solrmarc.index.indexer.AbstractValueIndexer;
import org.solrmarc.index.mapping.AbstractMultiValueMapping;
import org.solrmarc.index.mapping.AbstractValueMapping;

public class MultiValueIndexer
extends AbstractValueIndexer<Collection<String>> {
    private boolean onlyIfEmpty = false;
    private boolean onlyIfUnique = false;

    public MultiValueIndexer(String solrFieldNamesStr, AbstractMultiValueExtractor extractor, AbstractValueMapping<Collection<String>>[] mappings, MultiValueCollector collector) {
        super(solrFieldNamesStr, extractor, mappings, collector);
    }

    public MultiValueIndexer(String solrFieldNamesStr, AbstractMultiValueExtractor extractor, Collection<AbstractMultiValueMapping> mappings, MultiValueCollector collector) {
        super(solrFieldNamesStr, extractor, mappings.toArray(new AbstractMultiValueMapping[0]), collector);
    }

    public MultiValueIndexer(String solrFieldNamesStr, AbstractSingleValueExtractor extractor, AbstractValueMapping<Collection<String>>[] mappings, MultiValueCollector collector) {
        super(solrFieldNamesStr, new MultiValueWrapperSingleValueExtractor(extractor), mappings, collector);
    }

    public MultiValueIndexer(String solrFieldNamesStr, AbstractSingleValueExtractor extractor, Collection<AbstractMultiValueMapping> mappings, MultiValueCollector collector) {
        super(solrFieldNamesStr, new MultiValueWrapperSingleValueExtractor(extractor), mappings.toArray(new AbstractMultiValueMapping[0]), collector);
    }

    public MultiValueIndexer(String solrFieldNamesStr, AbstractMultiValueExtractor extractor, AbstractMultiValueMapping[] mappings, MultiValueCollector collector, String specLabel, AtomicLong totalElapsedTime) {
        super(solrFieldNamesStr, extractor, mappings, collector);
        this.totalElapsedTime = totalElapsedTime;
        this.setSpecLabel(specLabel);
    }

    @Override
    public Collection<String> getFieldData(Record record) throws Exception {
        long start = System.nanoTime();
        Collection<Object> values = this.extractor == null ? Collections.emptyList() : (Collection)this.extractor.extract(record);
        if (values == null) {
            values = Collections.emptyList();
        }
        for (AbstractValueMapping mapping : this.mappings) {
            if (mapping == null) continue;
            values = mapping.map(values);
        }
        Collection<String> result = this.collector.collect(values);
        long end = System.nanoTime();
        this.totalElapsedTime.addAndGet(end - start);
        return result;
    }

    @Override
    public void setIfEmpty() {
        this.onlyIfEmpty = true;
    }

    @Override
    public boolean getOnlyIfEmpty() {
        return this.onlyIfEmpty;
    }

    @Override
    public void setIfUnique() {
        this.onlyIfUnique = true;
    }

    @Override
    public boolean getOnlyIfUnique() {
        return this.onlyIfUnique;
    }
}

