/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.indexer;

public class IndexerSpecException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    String solrField;
    String spec;
    eErrorSeverity errLvl;
    String message;

    public IndexerSpecException(Throwable cause, String solrField, String spec, eErrorSeverity errLvl, String message) {
        this.init(cause, solrField, spec, errLvl, message);
    }

    private void init(Throwable cause, String solrField, String spec, eErrorSeverity errLvl, String message) {
        this.initCause(cause);
        this.solrField = solrField;
        this.spec = spec;
        this.message = message;
        this.errLvl = errLvl;
    }

    public IndexerSpecException(String solrField, String spec, eErrorSeverity errLvl, String message) {
        this.init(null, solrField, spec, errLvl, message);
    }

    public IndexerSpecException(String solrField, String spec, String message) {
        this.init(null, solrField, spec, eErrorSeverity.ERROR, message);
    }

    public IndexerSpecException(String solrFieldAndSpec, eErrorSeverity errLvl, String message) {
        String[] tmp = solrFieldAndSpec.split("[ ]*=[ ]*", 2);
        this.init(null, tmp.length >= 1 ? tmp[0] : null, tmp.length == 2 ? tmp[1] : null, errLvl, message);
    }

    public IndexerSpecException(String solrFieldAndSpec, String message) {
        String[] tmp = solrFieldAndSpec.split("[ ]*=[ ]*", 2);
        this.init(null, tmp.length >= 1 ? tmp[0] : null, tmp.length == 2 ? tmp[1] : null, eErrorSeverity.ERROR, message);
    }

    public IndexerSpecException(Throwable cause, eErrorSeverity errLvl, String message) {
        this.init(cause, null, null, errLvl, message);
    }

    public IndexerSpecException(Throwable cause, String message) {
        this.init(cause, null, null, eErrorSeverity.ERROR, message);
    }

    public IndexerSpecException(eErrorSeverity errLvl, String message) {
        this.init(null, null, null, errLvl, message);
    }

    public IndexerSpecException(String message) {
        this.init(null, null, null, eErrorSeverity.ERROR, message);
    }

    public void setSolrFieldAndSpec(String solrField, String spec) {
        this.solrField = solrField;
        this.spec = spec;
    }

    public String message() {
        return this.message;
    }

    public String getSolrField() {
        return this.solrField;
    }

    public String getSpecMessage() {
        StringBuilder build = new StringBuilder();
        if (this.solrField != null && this.spec != null) {
            build.append(this.solrField).append(" = ").append(this.spec);
        }
        return build.toString();
    }

    @Override
    public String getMessage() {
        StringBuilder build = new StringBuilder();
        if (this.message != null) {
            if (this.solrField != null) {
                build.append(this.solrField).append(" : ").append(this.message);
            } else {
                build.append(this.message);
            }
        }
        return build.toString();
    }

    public void setSolrFieldAndSpec(String solrFieldAndSpec) {
        String[] tmp = solrFieldAndSpec.split("[ ]*=[ ]*", 2);
        this.solrField = tmp[0];
        this.spec = tmp[1];
    }

    public eErrorSeverity getErrLvl() {
        return this.errLvl;
    }

    public void setErrLvl(eErrorSeverity errLvl) {
        this.errLvl = errLvl;
    }

    public static enum eErrorSeverity {
        NONE,
        INFO,
        WARN,
        ERROR,
        FATAL;


        public static eErrorSeverity max(eErrorSeverity errLvl1, eErrorSeverity errLvl2) {
            if (errLvl1.compareTo(errLvl2) > 0) {
                return errLvl1;
            }
            return errLvl2;
        }
    }
}

