/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.marc4j.marc.Record;
import org.solrmarc.index.collector.MultiValueCollector;
import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.mapping.AbstractValueMapping;

public abstract class AbstractValueIndexer<T> {
    private String solrFieldNamesStr;
    private Collection<String> solrFieldNames;
    protected final AbstractValueExtractor<T> extractor;
    protected AbstractValueMapping<T>[] mappings;
    protected final MultiValueCollector collector;
    private String specLabel;
    protected AtomicLong totalElapsedTime;

    public AbstractValueIndexer(String solrFieldNamesStr, AbstractValueExtractor<T> extractor, AbstractValueMapping<T>[] mappings, MultiValueCollector collector) {
        this.setSolrFieldNamesStr(solrFieldNamesStr);
        this.extractor = extractor;
        this.mappings = mappings;
        this.collector = collector;
        this.totalElapsedTime = new AtomicLong(0L);
    }

    public String getSpecLabel() {
        return this.specLabel;
    }

    public void setSpecLabel(String specLabel) {
        this.specLabel = specLabel;
    }

    public Collection<String> getFieldData(Record record) throws Exception {
        long start = System.nanoTime();
        if (this.extractor == null) {
            return Collections.emptyList();
        }
        T values = this.extractor.extract(record);
        if (values == null) {
            return Collections.emptyList();
        }
        for (AbstractValueMapping<T> mapping : this.mappings) {
            values = mapping.map(values);
        }
        Collection<String> result = null;
        if (values instanceof Collection) {
            result = this.collector.collect((Collection)values);
        } else if (values instanceof String) {
            result = this.collector.collect(Collections.singletonList((String)values));
        }
        long end = System.nanoTime();
        this.totalElapsedTime.addAndGet(end - start);
        return result;
    }

    public void getFieldData(Record record, Collection<String> result) throws Exception {
        long start = System.nanoTime();
        if (this.extractor == null) {
            return;
        }
        T values = this.extractor.extract(record);
        if (values == null) {
            return;
        }
        for (AbstractValueMapping<T> mapping : this.mappings) {
            values = mapping.map(values);
        }
        if (values instanceof Collection) {
            result.addAll(this.collector.collect((Collection)values));
        } else if (values instanceof String) {
            result.addAll(this.collector.collect(Collections.singletonList((String)values)));
        }
        long end = System.nanoTime();
        this.totalElapsedTime.addAndGet(end - start);
    }

    public Long getTotalElapsedTime() {
        return this.totalElapsedTime.get();
    }

    public Collection<String> getSolrFieldNames() {
        return this.solrFieldNames;
    }

    public String getSolrFieldNamesStr() {
        return this.solrFieldNamesStr;
    }

    public void setSolrFieldNamesStr(String solrFieldNamesStr) {
        this.solrFieldNamesStr = solrFieldNamesStr;
        this.solrFieldNames = AbstractValueIndexer.splitFieldNameStr(solrFieldNamesStr);
    }

    protected static Collection<String> splitFieldNameStr(String solrFieldNamesStr) {
        ArrayList<String> result = new ArrayList<String>();
        if (result != null) {
            String[] fieldNames;
            for (String fName : fieldNames = solrFieldNamesStr.trim().split("[ \\t]*,[ \\t]*")) {
                result.add(fName);
            }
        }
        return result;
    }

    public abstract void setIfEmpty();

    public abstract boolean getOnlyIfEmpty();

    public abstract void setIfUnique();

    public abstract boolean getOnlyIfUnique();
}

