/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.AbstractMethodCallFactory;
import org.solrmarc.index.extractor.methodcall.MethodCallManager;

public class MultiValueExtractorMethodCall
extends AbstractExtractorMethodCall<Collection<String>> {
    private final Object mixin;
    private final Method method;
    private final Method perRecordInit;

    public MultiValueExtractorMethodCall(Object mixin, Method method, Method perRecordInit, int numParameters) {
        super(mixin.getClass().getName(), method.getName(), perRecordInit != null, numParameters);
        this.mixin = mixin;
        this.method = method;
        this.perRecordInit = perRecordInit;
        if (!Collection.class.isAssignableFrom(this.method.getReturnType())) {
            throw new IllegalArgumentException("The method's return type has to be assignable to Collection:\nMixin class:  " + mixin.getClass().getName() + "\nMixin method: " + method.toString());
        }
    }

    private MultiValueExtractorMethodCall(MultiValueExtractorMethodCall toClone) {
        super(toClone.mixin.getClass().getName(), toClone.method.getName(), toClone.perRecordInit != null, toClone.getNumParameters());
        this.mixin = AbstractMethodCallFactory.createThreadLocalObjectForSpecifiedClass(toClone.mixin.getClass());
        this.method = toClone.method;
        this.perRecordInit = toClone.perRecordInit;
    }

    @Override
    protected boolean perRecordInitCalled(Object[] record) {
        return MethodCallManager.instance().alreadyCalledFor(this.mixin, record[0]);
    }

    @Override
    public void invokePerRecordInit(Object[] record) throws Exception {
        this.perRecordInit.invoke(this.mixin, record);
    }

    @Override
    public Collection<String> invoke(Object[] parameters) throws Exception {
        return (Collection)this.method.invoke(this.mixin, parameters);
    }

    @Override
    public boolean isThreadSafe() {
        if (this.perRecordInit != null) {
            return false;
        }
        try {
            Method isThreadSafe = this.mixin.getClass().getMethod("isThreadSafe", new Class[0]);
            if (isThreadSafe.getReturnType() != Boolean.TYPE) {
                return false;
            }
            boolean isSafe = (Boolean)isThreadSafe.invoke(this.mixin, new Object[0]);
            return isSafe;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new MultiValueExtractorMethodCall(this);
    }

    @Override
    public Class<?> getObjectClass() {
        return this.mixin.getClass();
    }
}

