/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.util.Collection;
import java.util.Collections;
import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;

public class MethodCallSingleValueExtractor
extends AbstractMultiValueExtractor
implements ExternalMethod {
    private final AbstractExtractorMethodCall<String> methodCall;
    private final Object[] parameters;

    public MethodCallSingleValueExtractor(AbstractExtractorMethodCall<String> methodCall, Object[] parameters) {
        if (methodCall == null) {
            throw new NullPointerException("CustomObject is null");
        }
        if (parameters == null) {
            throw new NullPointerException("Custom parameters is null");
        }
        this.methodCall = methodCall;
        this.parameters = new Object[parameters.length + 1];
        System.arraycopy(parameters, 0, this.parameters, 1, parameters.length);
    }

    private MethodCallSingleValueExtractor(MethodCallSingleValueExtractor toClone) {
        this.methodCall = (AbstractExtractorMethodCall)toClone.methodCall.makeThreadSafeCopy();
        this.parameters = new Object[toClone.parameters.length];
        System.arraycopy(toClone.parameters, 0, this.parameters, 0, toClone.parameters.length);
    }

    @Override
    public Collection<String> extract(Record record) throws Exception {
        String result = this.methodCall.invoke(record, this.parameters);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(result);
    }

    @Override
    public boolean isThreadSafe() {
        return this.methodCall.isThreadSafe();
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new MethodCallSingleValueExtractor(this);
    }
}

