/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.util.Collection;
import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.AbstractMultiValueExtractor;
import org.solrmarc.index.extractor.ExternalMethod;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;

public class MethodCallMultiValueExtractor
extends AbstractMultiValueExtractor
implements ExternalMethod {
    private final AbstractExtractorMethodCall<Collection<String>> methodCall;
    private final Object[] parameters;

    public MethodCallMultiValueExtractor(AbstractExtractorMethodCall<Collection<String>> methodCall, Object[] staticParameters) {
        if (methodCall == null) {
            throw new NullPointerException("CustomObject is null");
        }
        if (staticParameters == null) {
            throw new NullPointerException("Custom parameters is null");
        }
        this.methodCall = methodCall;
        this.parameters = new Object[staticParameters.length + 1];
        System.arraycopy(staticParameters, 0, this.parameters, 1, staticParameters.length);
    }

    private MethodCallMultiValueExtractor(MethodCallMultiValueExtractor toClone) {
        this.methodCall = (AbstractExtractorMethodCall)toClone.methodCall.makeThreadSafeCopy();
        this.parameters = new Object[toClone.parameters.length];
        System.arraycopy(toClone.parameters, 0, this.parameters, 0, toClone.parameters.length);
    }

    @Override
    public Collection<String> extract(Record record) throws Exception {
        return this.methodCall.invoke(record, this.parameters);
    }

    @Override
    public boolean isThreadSafe() {
        return this.methodCall.isThreadSafe();
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new MethodCallMultiValueExtractor(this);
    }
}

