/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.AbstractMappingMethodCall;
import org.solrmarc.index.extractor.methodcall.MethodCallContext;
import org.solrmarc.index.extractor.methodcall.MultiValueExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.MultiValueMappingMethodCall;
import org.solrmarc.index.extractor.methodcall.SingleValueExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.SingleValueMappingMethodCall;

public class MethodCallManager {
    private static MethodCallManager theManager = new MethodCallManager();
    private final Map<Object, String> perRecordInitMap = new ConcurrentHashMap<Object, String>();
    private final Map<String, AbstractExtractorMethodCall<?>> extractorMethodCalls = new HashMap();
    private final Map<String, AbstractMappingMethodCall<?>> mappingMethodCalls = new HashMap();
    private Set<Class<?>> classes = new HashSet();

    public static MethodCallManager instance() {
        return theManager;
    }

    private MethodCallManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneWithRecord(Record record) {
        String recId = record.getControlNumber();
        Map<Object, String> map = this.perRecordInitMap;
        synchronized (map) {
            Iterator<String> deleteIterator = this.perRecordInitMap.values().iterator();
            while (deleteIterator.hasNext()) {
                String value = deleteIterator.next();
                if (!value.equals(recId)) continue;
                deleteIterator.remove();
            }
        }
    }

    private boolean isPerRecordInitMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0].equals(Record.class) && Void.TYPE.isAssignableFrom(method.getReturnType()) && Modifier.isPublic(method.getModifiers());
    }

    private boolean isValidExtractorMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0 || !parameterTypes[0].equals(Record.class) || !Collection.class.isAssignableFrom(method.getReturnType()) && !String.class.isAssignableFrom(method.getReturnType()) || !Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        for (int i = 1; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == String.class) continue;
            return false;
        }
        return true;
    }

    private boolean isValidMappingMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!(parameterTypes.length > 0 && Modifier.isPublic(method.getModifiers()) && (Collection.class.isAssignableFrom(parameterTypes[0]) && Collection.class.isAssignableFrom(method.getReturnType()) || parameterTypes[0].equals(String.class) && method.getReturnType().equals(String.class)))) {
            return false;
        }
        for (int i = 1; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == String.class) continue;
            return false;
        }
        return true;
    }

    public void add(Object mixin) {
        Class<?> addedParentClass = this.getAddedParentClass(mixin);
        boolean addAsDefault = true;
        for (Class<?> currentClass = mixin.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            this.add(mixin, currentClass, addAsDefault &= currentClass != addedParentClass);
        }
    }

    private void add(Object mixin, Class<?> clazz, boolean addMethodsAsDefault) {
        this.classes.add(clazz);
        Method hasPerRecordInit = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.isPerRecordInitMethod(method)) continue;
            hasPerRecordInit = method;
            if (this.perRecordInitMap.containsKey(method)) continue;
            this.perRecordInitMap.put(method, "");
        }
        for (Method method : clazz.getDeclaredMethods()) {
            AbstractMappingMethodCall<?> methodCall;
            Class<?>[] parameterTypes;
            if (this.isValidExtractorMethod(method)) {
                parameterTypes = method.getParameterTypes();
                methodCall = null;
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    methodCall = this.createMultiValueExtractorMethodCall(mixin, method, hasPerRecordInit, parameterTypes.length);
                } else if (String.class.isAssignableFrom(method.getReturnType())) {
                    methodCall = this.createSingleValueExtractorMethodCall(mixin, method, hasPerRecordInit, parameterTypes.length);
                }
                if (addMethodsAsDefault) {
                    if (this.extractorMethodCalls.containsKey(this.toCacheKey(method, parameterTypes))) {
                        this.extractorMethodCalls.put(this.toCacheKey(method, parameterTypes), null);
                    } else {
                        this.extractorMethodCalls.put(this.toCacheKey(method, parameterTypes), (AbstractExtractorMethodCall<?>)((Object)methodCall));
                    }
                }
                this.extractorMethodCalls.put(this.toCacheKey(mixin, method, parameterTypes), (AbstractExtractorMethodCall<?>)((Object)methodCall));
                continue;
            }
            if (!this.isValidMappingMethod(method)) continue;
            parameterTypes = method.getParameterTypes();
            methodCall = null;
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                methodCall = this.createMultiValueMappingMethodCall(mixin, method);
            } else if (method.getReturnType().equals(String.class)) {
                methodCall = this.createSingleValueMappingMethodCall(mixin, method);
            }
            if (addMethodsAsDefault) {
                this.mappingMethodCalls.put(this.toCacheKey(method, parameterTypes), methodCall);
            }
            this.mappingMethodCalls.put(this.toCacheKey(mixin, method, parameterTypes), methodCall);
        }
    }

    protected AbstractMappingMethodCall<?> createMultiValueMappingMethodCall(Object object, Method method) {
        return new MultiValueMappingMethodCall(object, method);
    }

    protected AbstractMappingMethodCall<?> createSingleValueMappingMethodCall(Object object, Method method) {
        return new SingleValueMappingMethodCall(object, method);
    }

    protected SingleValueExtractorMethodCall createSingleValueExtractorMethodCall(Object object, Method method, Method perRecordInit, int numParameters) {
        return new SingleValueExtractorMethodCall(object, method, perRecordInit, numParameters);
    }

    protected MultiValueExtractorMethodCall createMultiValueExtractorMethodCall(Object object, Method method, Method perRecordInit, int numParameters) {
        return new MultiValueExtractorMethodCall(object, method, perRecordInit, numParameters);
    }

    private Class<?> getAddedParentClass(Object mixin) {
        for (Class<?> mixinClass = mixin.getClass().getSuperclass(); mixinClass != null; mixinClass = mixinClass.getSuperclass()) {
            if (!this.classes.contains(mixinClass)) continue;
            return mixinClass;
        }
        return null;
    }

    public AbstractExtractorMethodCall<?> getExtractorMethodCallForContext(MethodCallContext context) {
        String key = this.toCacheKey(context.getObjectName(), context.getMethodName(), context.getParameterTypes());
        return this.extractorMethodCalls.get(key);
    }

    public AbstractMappingMethodCall<?> getMappingMethodCallForContext(MethodCallContext context) {
        String key = this.toCacheKey(context.getObjectName(), context.getMethodName(), context.getParameterTypes());
        return this.mappingMethodCalls.get(key);
    }

    private String toCacheKey(Object mixin, Method method, Class<?> ... pameterTypes) {
        return this.toCacheKey(mixin.getClass().getName(), method.getName(), pameterTypes);
    }

    private String toCacheKey(Method method, Class<?> ... parameterTypes) {
        return this.toCacheKey(null, method.getName(), parameterTypes);
    }

    private String toCacheKey(String className, String methodName, Class<?> ... parameterTypes) {
        return className + ';' + methodName + ';' + parameterTypes.length;
    }

    public String loadedExtractorMixinsToString() {
        return this.loadedExtractorMixinsToString(this.getLoadedExtractorMixinsMatches(null, null, -1));
    }

    public List<AbstractExtractorMethodCall<?>> getLoadedExtractorMixinsMatches(String classNameToMatch, String methodNameToMatch, int numParameters) {
        ArrayList result = new ArrayList();
        for (String key : this.extractorMethodCalls.keySet()) {
            if (key.startsWith("null")) continue;
            AbstractExtractorMethodCall<?> call = this.extractorMethodCalls.get(key);
            if (classNameToMatch != null && !classNameToMatch.equals(call.getObjectName()) || methodNameToMatch != null && !methodNameToMatch.equals(call.getMethodName()) || numParameters != -1 && numParameters != call.getNumParameters()) continue;
            result.add(call);
        }
        return result;
    }

    public String loadedExtractorMixinsToString(List<AbstractExtractorMethodCall<?>> matches) {
        ArrayList<String> lines = new ArrayList<String>(matches.size());
        for (AbstractExtractorMethodCall<?> call : matches) {
            lines.add("- " + call.getObjectName() + "::" + call.getMethodName());
        }
        Collections.sort(lines);
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }

    public String loadedMappingMixinsToString() {
        ArrayList<String> lines = new ArrayList<String>(this.mappingMethodCalls.size());
        for (String key : this.mappingMethodCalls.keySet()) {
            if (key.startsWith("null")) continue;
            AbstractMappingMethodCall<?> call = this.mappingMethodCalls.get(key);
            lines.add("- " + call.getObjectName() + "::" + call.getMethodName());
        }
        Collections.sort(lines);
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append('\n');
        }
        return buffer.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean alreadyCalledFor(Object objectWithPerRecordInit, Object record) {
        String recId = "";
        if (record instanceof Record) {
            Record rec = (Record)record;
            recId = rec.getControlNumber();
        }
        boolean returnValue = true;
        Map<Object, String> map = this.perRecordInitMap;
        synchronized (map) {
            String result = this.perRecordInitMap.get(objectWithPerRecordInit);
            if (result == null || !result.equals(recId)) {
                this.perRecordInitMap.put(objectWithPerRecordInit, recId);
                returnValue = false;
            }
        }
        return returnValue;
    }
}

