/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.util.Arrays;
import org.marc4j.marc.Record;

public class MethodCallContext {
    private String typeName;
    private String objectName;
    private String methodName;
    private String[] parameters;
    private Class<?>[] parameterTypes;

    protected MethodCallContext(String typeName, String objectName, String methodName, String[] parameters, Class<?>[] parameterTypes) {
        this.typeName = typeName;
        this.objectName = objectName;
        this.methodName = methodName;
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
    }

    public static MethodCallContext parseContextFromExtractorParts(String[] extParts) {
        String typeName = extParts[0];
        String objectName = extParts[1];
        String methodName = extParts[2];
        String[] parameters = MethodCallContext.getParameters(extParts, 3);
        Class<?>[] parameterTypes = MethodCallContext.getExtractorParameterTypes(parameters);
        return new MethodCallContext(typeName, objectName, methodName, parameters, parameterTypes);
    }

    public static MethodCallContext parseContextFromMapParts(String[] mapParts) {
        String typeName = mapParts[0];
        String objectName = mapParts[1];
        String methodName = mapParts[2];
        String[] parameters = MethodCallContext.getParameters(mapParts, 3);
        Class<?>[] parameterTypes = MethodCallContext.getMappingParameterTypes(parameters);
        return new MethodCallContext(typeName, objectName, methodName, parameters, parameterTypes);
    }

    protected static Class<?>[] getExtractorParameterTypes(String[] parameters) {
        Object[] parameterTypes = new Class[parameters.length + 1];
        parameterTypes[0] = Record.class;
        Arrays.fill(parameterTypes, 1, parameters.length + 1, String.class);
        return parameterTypes;
    }

    protected static Class<?>[] getMappingParameterTypes(String[] parameters) {
        Object[] parameterTypes = new Class[parameters.length + 1];
        parameterTypes[0] = Object.class;
        Arrays.fill(parameterTypes, 1, parameters.length + 1, String.class);
        return parameterTypes;
    }

    private static String[] getParameters(String[] mapParts, int numToDiscard) {
        if (mapParts.length <= numToDiscard) {
            return new String[0];
        }
        String[] result = new String[mapParts.length - numToDiscard];
        System.arraycopy(mapParts, numToDiscard, result, 0, mapParts.length - numToDiscard);
        return result;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return this.objectName + "." + this.methodName + Arrays.toString(this.parameterTypes);
    }
}

