/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.solrmarc.index.SolrIndexer;
import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.MethodCallContext;
import org.solrmarc.index.extractor.methodcall.MethodCallManager;
import org.solrmarc.index.extractor.methodcall.MethodCallMultiValueExtractor;
import org.solrmarc.index.extractor.methodcall.MethodCallSingleValueExtractor;
import org.solrmarc.index.extractor.methodcall.MultiValueExtractorMethodCall;
import org.solrmarc.index.extractor.methodcall.SingleValueExtractorMethodCall;
import org.solrmarc.index.indexer.IndexerSpecException;
import org.solrmarc.index.indexer.ValueIndexerFactory;

public abstract class AbstractMethodCallFactory
extends AbstractValueExtractorFactory {
    protected final MethodCallManager methodCallManager;
    protected boolean haveShownKnownMethods = false;
    private static final ThreadLocal<Map<Class<?>, Object>> threadLocalObjectMap = new ThreadLocal<Map<Class<?>, Object>>(){

        @Override
        protected Map<Class<?>, Object> initialValue() {
            return new LinkedHashMap();
        }
    };

    public AbstractMethodCallFactory() {
        this(MethodCallManager.instance());
    }

    public AbstractMethodCallFactory(MethodCallManager methodCallManager) {
        this.methodCallManager = methodCallManager;
    }

    public void addMethodsFromClasses(Collection<Class<?>> classes) {
        for (Class<?> aClass : classes) {
            Object instance = AbstractMethodCallFactory.createThreadLocalObjectForSpecifiedClass(aClass);
            if (instance == null) continue;
            this.methodCallManager.add(instance);
        }
    }

    public static Object createThreadLocalObjectForSpecifiedClass(Class<?> aClass) {
        Object toReturn;
        Map<Class<?>, Object> instanceMap = threadLocalObjectMap.get();
        if (instanceMap.containsKey(aClass)) {
            return instanceMap.get(aClass);
        }
        try {
            Constructor<?> ctor = aClass.getConstructor(new Class[0]);
            toReturn = ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Class<SolrIndexer> solrIndexerClass = SolrIndexer.class;
            if (solrIndexerClass.isAssignableFrom(aClass)) {
                try {
                    Constructor<?> ctor2 = aClass.getConstructor(String.class, String[].class);
                    toReturn = ctor2.newInstance("", ValueIndexerFactory.instance().getHomeDirs());
                }
                catch (NoSuchMethodException | SecurityException e1) {
                    throw new RuntimeException("Cannot call constructor for legacy class derived from old SolrIndexer, you'll need to edit your source code", e);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e2) {
                    throw new RuntimeException("Cannot call constructor for legacy class derived from old SolrIndexer, you'll need to edit your source code", e);
                }
            }
            toReturn = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        instanceMap.put(aClass, toReturn);
        return toReturn;
    }

    public AbstractValueExtractor<?> createExtractor(String solrFieldName, MethodCallContext context) {
        AbstractExtractorMethodCall<?> methodCall = this.methodCallManager.getExtractorMethodCallForContext(context);
        if (methodCall != null) {
            return this.createExtractorForMethodCall(methodCall, context);
        }
        if (methodCall == null && context.getObjectName() == null) {
            List<AbstractExtractorMethodCall<?>> matches = this.methodCallManager.getLoadedExtractorMixinsMatches(null, context.getMethodName(), context.getParameterTypes().length);
            if (matches.size() > 1) {
                if (matches.size() == 2) {
                    Class<?> clazz;
                    Class<?> class0 = matches.get(0).getObjectClass();
                    if (!class0.equals(clazz = matches.get(1).getObjectClass()) && class0.isAssignableFrom(clazz)) {
                        AbstractExtractorMethodCall<?> derivedMethodCall = matches.get(1);
                        return this.createExtractorForMethodCall(derivedMethodCall, context);
                    }
                    if (!class0.equals(clazz) && clazz.isAssignableFrom(class0)) {
                        AbstractExtractorMethodCall<?> derivedMethodCall = matches.get(0);
                        return this.createExtractorForMethodCall(derivedMethodCall, context);
                    }
                }
                if (ValueIndexerFactory.instance().getDefaultCustomClassname() != null) {
                    for (AbstractExtractorMethodCall abstractExtractorMethodCall : matches) {
                        if (!abstractExtractorMethodCall.getObjectClass().getName().equals(ValueIndexerFactory.instance().getDefaultCustomClassname())) continue;
                        return this.createExtractorForMethodCall(abstractExtractorMethodCall, context);
                    }
                }
                throw new IndexerSpecException("Multiple methods with name: " + context.getMethodName() + " you must specify the class of the method you intend to use.  Known methods are: \n" + this.methodCallManager.loadedExtractorMixinsToString(matches));
            }
            if (matches.size() == 0) {
                List<AbstractExtractorMethodCall<?>> matchesParmWildcard = this.methodCallManager.getLoadedExtractorMixinsMatches(null, context.getMethodName(), -1);
                if (matchesParmWildcard.size() == 1) {
                    int n = matchesParmWildcard.iterator().next().getNumParameters() - 1;
                    throw new IndexerSpecException("Incorrect number of parameters to method: " + context.getMethodName() + " The known method " + this.methodCallManager.loadedExtractorMixinsToString(matchesParmWildcard) + " requires " + n + " parameter" + (n == 1 ? "" : "s") + "\n");
                }
                if (matchesParmWildcard.size() > 1) {
                    throw new IndexerSpecException("Multiple methods with name: " + context.getMethodName() + " but none of them require " + context.getParameterTypes().length + " parameters.  Known methods are: \n" + this.methodCallManager.loadedExtractorMixinsToString(matchesParmWildcard));
                }
            }
            if (!this.haveShownKnownMethods) {
                this.haveShownKnownMethods = true;
                throw new IndexerSpecException("Unknown extractor method: " + context.toString() + ". Known methods are: \n" + this.methodCallManager.loadedExtractorMixinsToString());
            }
            throw new IndexerSpecException("Unknown extractor method: " + context.toString());
        }
        List<AbstractExtractorMethodCall<?>> matchesOtherContext = this.methodCallManager.getLoadedExtractorMixinsMatches(null, context.getMethodName(), context.getParameterTypes().length);
        if (matchesOtherContext.size() == 1) {
            String objName = matchesOtherContext.iterator().next().getObjectName();
            throw new IndexerSpecException("Method not found in specified class: " + context.getObjectName() + " A known method does exist in the class : " + objName + "\n");
        }
        List<AbstractExtractorMethodCall<?>> matchesParmWildcard = this.methodCallManager.getLoadedExtractorMixinsMatches(context.getObjectName(), context.getMethodName(), -1);
        if (matchesParmWildcard.size() == 1) {
            int n = matchesParmWildcard.iterator().next().getNumParameters() - 1;
            throw new IndexerSpecException("Incorrect number of parameters to method: " + context.getMethodName() + " The known method " + this.methodCallManager.loadedExtractorMixinsToString(matchesParmWildcard) + " requires " + n + " parameter" + (n == 1 ? "" : "s") + "\n");
        }
        List<AbstractExtractorMethodCall<?>> list = this.methodCallManager.getLoadedExtractorMixinsMatches(null, context.getMethodName(), -1);
        if (list.size() == 1) {
            AbstractExtractorMethodCall<?> match = list.iterator().next();
            throw new IndexerSpecException("Specified method with name: " + context.getMethodName() + " not found.  Closest match is: \n" + this.methodCallManager.loadedExtractorMixinsToString(list));
        }
        if (list.size() > 1) {
            throw new IndexerSpecException("Multiple methods with name: " + context.getMethodName() + " but none of them require " + context.getParameterTypes().length + " parameters.  Known methods are: \n" + this.methodCallManager.loadedExtractorMixinsToString(list));
        }
        if (!this.haveShownKnownMethods) {
            this.haveShownKnownMethods = true;
            throw new IndexerSpecException("Unknown extractor method: " + context.toString() + ". Known methods are: \n" + this.methodCallManager.loadedExtractorMixinsToString());
        }
        throw new IndexerSpecException("Unknown extractor method: " + context.toString());
    }

    private AbstractValueExtractor<?> createExtractorForMethodCall(AbstractExtractorMethodCall<?> methodCall, MethodCallContext context) {
        if (methodCall instanceof MultiValueExtractorMethodCall) {
            return new MethodCallMultiValueExtractor((MultiValueExtractorMethodCall)methodCall, context.getParameters());
        }
        if (methodCall instanceof SingleValueExtractorMethodCall) {
            return new MethodCallSingleValueExtractor((SingleValueExtractorMethodCall)methodCall, context.getParameters());
        }
        return null;
    }

    @Override
    public AbstractValueExtractor<?> createExtractor(String solrFieldName, String[] parts) {
        MethodCallContext context = MethodCallContext.parseContextFromExtractorParts(parts);
        return this.createExtractor(solrFieldName, context);
    }
}

