/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.methodcall;

import org.marc4j.marc.Record;
import org.solrmarc.index.extractor.ExternalMethod;

public abstract class AbstractExtractorMethodCall<T>
implements ExternalMethod {
    private final String objectName;
    private final String methodName;
    private final int numParameters;
    private final boolean hasPerRecordInit;

    protected AbstractExtractorMethodCall(String objectName, String methodName, boolean hasPerRecordInit, int numParameters) {
        this.objectName = objectName;
        this.methodName = methodName;
        this.hasPerRecordInit = hasPerRecordInit;
        this.numParameters = numParameters;
    }

    public T invoke(Record record, Object[] parameters) throws Exception {
        parameters[0] = record;
        if (this.hasPerRecordInit && !this.perRecordInitCalled(new Object[]{record})) {
            this.invokePerRecordInit(new Object[]{record});
        }
        return this.invoke(parameters);
    }

    protected abstract boolean perRecordInitCalled(Object[] var1);

    protected abstract void invokePerRecordInit(Object[] var1) throws Exception;

    public abstract T invoke(Object[] var1) throws Exception;

    public String getObjectName() {
        return this.objectName;
    }

    public abstract Class<?> getObjectClass();

    public String getMethodName() {
        return this.methodName;
    }

    public int getNumParameters() {
        return this.numParameters;
    }
}

