/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.script;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.UtilEvalError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.solrmarc.index.SolrIndexer;
import org.solrmarc.index.extractor.AbstractValueExtractor;
import org.solrmarc.index.extractor.AbstractValueExtractorFactory;
import org.solrmarc.index.extractor.impl.script.ScriptMultiValueMethodCall;
import org.solrmarc.index.extractor.impl.script.ScriptSingleValueMethodCall;
import org.solrmarc.index.extractor.methodcall.MethodCallContext;
import org.solrmarc.index.extractor.methodcall.MethodCallMultiValueExtractor;
import org.solrmarc.index.extractor.methodcall.MethodCallSingleValueExtractor;
import org.solrmarc.index.indexer.ValueIndexerFactory;
import org.solrmarc.tools.PropertyUtils;

public class ScriptValueExtractorFactory
extends AbstractValueExtractorFactory {
    private static final Logger logger = Logger.getLogger(ScriptValueExtractorFactory.class);
    private static final Map<String, Interpreter> INTERPRETERS = new HashMap<String, Interpreter>();
    private static Map<String, BshMethod> methods = new HashMap<String, BshMethod>();

    private Interpreter getInterpreter(String scriptFileName) {
        Interpreter bsh = INTERPRETERS.get(scriptFileName);
        if (bsh != null) {
            return bsh;
        }
        logger.debug((Object)("Load bean shell script: " + scriptFileName));
        bsh = new Interpreter();
        bsh.setClassLoader(this.getClass().getClassLoader());
        String[] paths = new String[ValueIndexerFactory.instance().getHomeDirs().length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ValueIndexerFactory.instance().getHomeDirs()[i] + File.separator + "index_scripts";
        }
        String[] inputSource = new String[1];
        InputStream script = PropertyUtils.getPropertyFileInputStream(paths, scriptFileName, false, inputSource);
        try {
            bsh.setOut(System.out);
            bsh.setErr(System.err);
            bsh.eval((Reader)new InputStreamReader(script), bsh.getNameSpace(), inputSource[0]);
            bsh.set("indexer", (Object)SolrIndexer.instance());
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("Unable to evaluate script: " + scriptFileName, e);
        }
        try {
            script.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        INTERPRETERS.put(scriptFileName, bsh);
        return bsh;
    }

    private BshMethod getBeanShellMethod(Interpreter interpreter, String methodName, Class<?>[] parameterTypes) {
        BshMethod method = methods.get(methodName + Arrays.toString(parameterTypes));
        if (method != null) {
            return method;
        }
        try {
            method = interpreter.getNameSpace().getMethod(methodName, (Class[])parameterTypes);
            methods.put(methodName + Arrays.toString(parameterTypes), method);
            return method;
        }
        catch (UtilEvalError e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean canHandle(String solrFieldName, String mappingConfiguration) {
        return mappingConfiguration.trim().startsWith("script");
    }

    private AbstractValueExtractor<?> createExtractor(String solrFieldName, MethodCallContext context) {
        String scriptFileName = context.getObjectName();
        Interpreter interpreter = this.getInterpreter(scriptFileName);
        BshMethod method = this.getBeanShellMethod(interpreter, context.getMethodName(), context.getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("Couldn't find bean shell method " + context.getMethodName() + Arrays.toString(context.getParameters()) + " in script file " + scriptFileName);
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            return new MethodCallMultiValueExtractor(new ScriptMultiValueMethodCall(interpreter, method, scriptFileName, context.getParameters().length), context.getParameters());
        }
        return new MethodCallSingleValueExtractor(new ScriptSingleValueMethodCall(interpreter, method, scriptFileName, context.getParameters().length), context.getParameters());
    }

    @Override
    public AbstractValueExtractor<?> createExtractor(String solrFieldName, String[] parts) {
        MethodCallContext context = MethodCallContext.parseContextFromExtractorParts(parts);
        return this.createExtractor(solrFieldName, context);
    }
}

