/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.script;

import bsh.BshMethod;
import bsh.Interpreter;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;

public class ScriptSingleValueMethodCall
extends AbstractExtractorMethodCall<String> {
    private final Interpreter interpreter;
    private final BshMethod method;

    public ScriptSingleValueMethodCall(Interpreter interpreter, BshMethod method, String scriptFileName, int numParameters) {
        super(scriptFileName, method.getName(), false, numParameters);
        this.interpreter = interpreter;
        this.method = method;
        if (this.interpreter == null) {
            throw new NullPointerException("Interpreter is null.");
        }
        if (!String.class.isAssignableFrom(this.method.getReturnType())) {
            throw new IllegalArgumentException("The method's return type has to be assignable to String:\nScript:  " + scriptFileName + "\nMethod: " + method.toString());
        }
    }

    private ScriptSingleValueMethodCall(ScriptSingleValueMethodCall toClone) {
        super(toClone.getObjectName(), toClone.method.getName(), false, toClone.getNumParameters());
        this.interpreter = toClone.interpreter;
        this.method = toClone.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invoke(Object[] parameters) throws Exception {
        Object result;
        Interpreter interpreter = this.interpreter;
        synchronized (interpreter) {
            result = this.method.invoke(parameters, this.interpreter);
        }
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    @Override
    public void invokePerRecordInit(Object[] record) throws Exception {
    }

    @Override
    protected boolean perRecordInitCalled(Object[] record) {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new ScriptSingleValueMethodCall(this);
    }

    @Override
    public Class<?> getObjectClass() {
        return null;
    }
}

