/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.index.extractor.impl.script;

import bsh.BshMethod;
import bsh.Interpreter;
import java.util.Collection;
import org.solrmarc.index.extractor.methodcall.AbstractExtractorMethodCall;

public class ScriptMultiValueMethodCall
extends AbstractExtractorMethodCall<Collection<String>> {
    private final Interpreter interpreter;
    private final BshMethod method;

    public ScriptMultiValueMethodCall(Interpreter interpreter, BshMethod method, String scriptFileName, int numParameters) {
        super(scriptFileName, method.getName(), false, numParameters);
        this.interpreter = interpreter;
        this.method = method;
        if (this.interpreter == null) {
            throw new NullPointerException("Interpreter is null.");
        }
        if (!Collection.class.isAssignableFrom(this.method.getReturnType())) {
            throw new IllegalArgumentException("The method's return type has to be assignable to Collection:\nScript:  " + scriptFileName + "\nMethod: " + method.toString());
        }
    }

    private ScriptMultiValueMethodCall(ScriptMultiValueMethodCall toClone) {
        super(toClone.getObjectName(), toClone.method.getName(), false, toClone.getNumParameters());
        this.interpreter = toClone.interpreter;
        this.method = toClone.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> invoke(Object[] parameters) throws Exception {
        Object result;
        Interpreter interpreter = this.interpreter;
        synchronized (interpreter) {
            result = this.method.invoke(parameters, this.interpreter);
        }
        if (result instanceof Collection) {
            return (Collection)result;
        }
        return null;
    }

    @Override
    public void invokePerRecordInit(Object[] record) throws Exception {
    }

    @Override
    protected boolean perRecordInitCalled(Object[] record) {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public Object makeThreadSafeCopy() {
        return new ScriptMultiValueMethodCall(this);
    }

    @Override
    public Class<?> getObjectClass() {
        return null;
    }
}

